/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueuer;

public class NewSessionQueuerOptions {
    private static final String SESSION_QUEUER_SECTION = "sessionqueuer";
    private final Config config;

    public NewSessionQueuerOptions(Config config) {
        this.config = config;
    }

    public URI getSessionQueuerUri() {
        Optional<URI> host = this.config.get(SESSION_QUEUER_SECTION, "host").map(str -> {
            try {
                return new URI((String)str);
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Session queuer server URI is not a valid URI: " + str, new Object[0]);
            }
        });
        if (host.isPresent()) {
            return host.get();
        }
        Optional<Integer> port = this.config.getInt(SESSION_QUEUER_SECTION, "port");
        Optional<String> hostname = this.config.get(SESSION_QUEUER_SECTION, "hostname");
        if (!port.isPresent() || !hostname.isPresent()) {
            throw new ConfigException("Unable to determine host and port for the session queuer server", new Object[0]);
        }
        try {
            return new URI("http", null, hostname.get(), port.get(), "", null, null);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Session queuer server uri configured through host (%s) and port (%d) is not a valid URI", hostname.get(), port.get());
        }
    }

    public NewSessionQueuer getSessionQueuer(String implementation) {
        return this.config.getClass(SESSION_QUEUER_SECTION, "implementation", NewSessionQueuer.class, implementation);
    }
}

