/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.remote;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.security.AddSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueuer;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueuerOptions;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;

public class RemoteNewSessionQueuer
extends NewSessionQueuer {
    private static final String timestampHeader = "new-session-request-timestamp";
    private static final String reqIdHeader = "request-id";
    private final HttpClient client;
    private final Filter addSecret;

    public RemoteNewSessionQueuer(Tracer tracer, HttpClient client, Secret registrationSecret) {
        super(tracer, registrationSecret);
        this.client = (HttpClient)Require.nonNull((String)"HTTP client", (Object)client);
        Require.nonNull((String)"Registration secret", (Object)registrationSecret);
        this.addSecret = new AddSecretFilter(registrationSecret);
    }

    public static NewSessionQueuer create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        URI uri = new NewSessionQueuerOptions(config).getSessionQueuerUri();
        HttpClient.Factory clientFactory = new NetworkOptions(config).getHttpClientFactory(tracer);
        SecretOptions secretOptions = new SecretOptions(config);
        Secret registrationSecret = secretOptions.getRegistrationSecret();
        try {
            return new RemoteNewSessionQueuer(tracer, clientFactory.createClient(uri.toURL()), registrationSecret);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public HttpResponse addToQueue(HttpRequest request) {
        HttpRequest upstream = new HttpRequest(HttpMethod.POST, "/se/grid/newsessionqueuer/session");
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        upstream.setContent(request.getContent());
        return this.client.execute(upstream);
    }

    @Override
    public boolean retryAddToQueue(HttpRequest request, RequestId reqId) {
        HttpRequest upstream = new HttpRequest(HttpMethod.POST, "/se/grid/newsessionqueuer/session/retry/" + reqId.toString());
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        upstream.setContent(request.getContent());
        upstream.setHeader(timestampHeader, request.getHeader(timestampHeader));
        upstream.setHeader(reqIdHeader, reqId.toString());
        HttpResponse response = this.client.with(this.addSecret).execute(upstream);
        return (Boolean)Values.get(response, Boolean.class);
    }

    @Override
    public Optional<HttpRequest> remove(RequestId reqId) {
        HttpRequest upstream = new HttpRequest(HttpMethod.GET, "/se/grid/newsessionqueuer/session/" + reqId.toString());
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        HttpResponse response = this.client.with(this.addSecret).execute(upstream);
        if (response.getStatus() == 200) {
            HttpRequest httpRequest = new HttpRequest(HttpMethod.POST, "/session");
            httpRequest.setContent(response.getContent());
            httpRequest.setHeader(timestampHeader, response.getHeader(timestampHeader));
            httpRequest.setHeader(reqIdHeader, response.getHeader(reqIdHeader));
            return Optional.ofNullable(httpRequest);
        }
        return Optional.empty();
    }

    @Override
    public int clearQueue() {
        HttpRequest upstream = new HttpRequest(HttpMethod.DELETE, "/se/grid/newsessionqueuer/queue");
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        HttpResponse response = this.client.with(this.addSecret).execute(upstream);
        return (Integer)Values.get(response, Integer.class);
    }

    @Override
    public List<Object> getQueueContents() {
        HttpRequest upstream = new HttpRequest(HttpMethod.GET, "/se/grid/newsessionqueuer/queue");
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        HttpResponse response = this.client.execute(upstream);
        return (List)Values.get(response, List.class);
    }

    @Override
    public boolean isReady() {
        try {
            return this.client.execute(new HttpRequest(HttpMethod.GET, "/readyz")).isSuccessful();
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

