/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.local;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.sessionqueue.GetNewSessionResponse;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueuer;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.grid.sessionqueue.local.LocalNewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.Tracer;

public class LocalNewSessionQueuer
extends NewSessionQueuer {
    public final NewSessionQueue sessionRequests;
    private final EventBus bus;
    private final GetNewSessionResponse getNewSessionResponse;

    public LocalNewSessionQueuer(Tracer tracer, EventBus bus, NewSessionQueue sessionRequests, Secret registrationSecret) {
        super(tracer, registrationSecret);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        this.sessionRequests = (NewSessionQueue)Require.nonNull((String)"New Session Request Queue", (Object)sessionRequests);
        this.getNewSessionResponse = new GetNewSessionResponse(tracer, bus, sessionRequests);
    }

    public static NewSessionQueuer create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        Duration retryInterval = new NewSessionQueueOptions(config).getSessionRequestRetryInterval();
        Duration requestTimeout = new NewSessionQueueOptions(config).getSessionRequestTimeout();
        LocalNewSessionQueue sessionRequests = new LocalNewSessionQueue(tracer, bus, retryInterval, requestTimeout);
        SecretOptions secretOptions = new SecretOptions(config);
        Secret registrationSecret = secretOptions.getRegistrationSecret();
        return new LocalNewSessionQueuer(tracer, bus, sessionRequests, registrationSecret);
    }

    @Override
    public HttpResponse addToQueue(HttpRequest request) {
        this.validateSessionRequest(request);
        return this.getNewSessionResponse.add(request);
    }

    @Override
    public boolean retryAddToQueue(HttpRequest request, RequestId reqId) {
        return this.sessionRequests.offerFirst(request, reqId);
    }

    @Override
    public Optional<HttpRequest> remove(RequestId id) {
        return this.sessionRequests.remove(id);
    }

    @Override
    public int clearQueue() {
        return this.sessionRequests.clear();
    }

    @Override
    public List<Object> getQueueContents() {
        return this.sessionRequests.getQueuedRequests();
    }

    @Override
    public boolean isReady() {
        return this.bus.isReady();
    }
}

