/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.local;

import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Beta;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.RetrySessionRequestException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.concurrent.Regularly;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NewSessionErrorResponse;
import org.openqa.selenium.grid.data.NewSessionRejectedEvent;
import org.openqa.selenium.grid.data.NewSessionRequestEvent;
import org.openqa.selenium.grid.data.NewSessionResponse;
import org.openqa.selenium.grid.data.NewSessionResponseEvent;
import org.openqa.selenium.grid.data.NodeAddedEvent;
import org.openqa.selenium.grid.data.NodeDrainComplete;
import org.openqa.selenium.grid.data.NodeHeartBeatEvent;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeRemovedEvent;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.NodeStatusEvent;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.distributor.local.GridModel;
import org.openqa.selenium.grid.distributor.selector.DefaultSlotSelector;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.node.HealthCheck;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.remote.RemoteNode;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.config.SessionMapOptions;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueuer;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueuerOptions;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public class LocalDistributor
extends Distributor {
    private static final Logger LOG = Logger.getLogger(LocalDistributor.class.getName());
    private final Tracer tracer;
    private final EventBus bus;
    private final HttpClient.Factory clientFactory;
    private final SessionMap sessions;
    private final Secret registrationSecret;
    private final Regularly hostChecker = new Regularly("distributor host checker");
    private final Map<NodeId, Runnable> allChecks = new HashMap<NodeId, Runnable>();
    private final Queue<RequestId> requestIds = new ConcurrentLinkedQueue<RequestId>();
    private final ScheduledExecutorService executorService;
    private final Duration healthcheckInterval;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final GridModel model;
    private final Map<NodeId, Node> nodes;
    private final NewSessionQueuer sessionRequests;

    public LocalDistributor(Tracer tracer, EventBus bus, HttpClient.Factory clientFactory, SessionMap sessions, NewSessionQueuer sessionRequests, Secret registrationSecret, Duration healthcheckInterval) {
        super(tracer, clientFactory, new DefaultSlotSelector(), sessions, registrationSecret);
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        this.clientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client factory", (Object)clientFactory);
        this.sessions = (SessionMap)Require.nonNull((String)"Session map", (Object)sessions);
        this.model = new GridModel(bus);
        this.nodes = new HashMap<NodeId, Node>();
        this.sessionRequests = (NewSessionQueuer)Require.nonNull((String)"New Session Request Queue", (Object)sessionRequests);
        this.registrationSecret = (Secret)Require.nonNull((String)"Registration secret", (Object)registrationSecret);
        this.healthcheckInterval = (Duration)Require.nonNull((String)"Health check interval", (Object)healthcheckInterval);
        bus.addListener(NodeStatusEvent.listener(this::register));
        bus.addListener(NodeStatusEvent.listener(this.model::refresh));
        bus.addListener(NodeHeartBeatEvent.listener(this.model::touch));
        bus.addListener(NodeDrainComplete.listener(this::remove));
        bus.addListener(NewSessionRequestEvent.listener(this.requestIds::offer));
        Regularly regularly = new Regularly("Local Distributor");
        regularly.submit(this.model::purgeDeadNodes, Duration.ofSeconds(30L), Duration.ofSeconds(30L));
        Thread shutdownHook = new Thread(this::callExecutorShutdown);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        NewSessionRunnable runnable = new NewSessionRunnable();
        ThreadFactory threadFactory = r -> {
            Thread thread = new Thread(r);
            thread.setName("New Session Creation");
            thread.setDaemon(true);
            return thread;
        };
        this.executorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.executorService.scheduleAtFixedRate(runnable, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    public static Distributor create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        DistributorOptions distributorOptions = new DistributorOptions(config);
        HttpClient.Factory clientFactory = new NetworkOptions(config).getHttpClientFactory(tracer);
        SessionMap sessions = new SessionMapOptions(config).getSessionMap();
        SecretOptions secretOptions = new SecretOptions(config);
        NewSessionQueuer sessionRequests = new NewSessionQueuerOptions(config).getSessionQueuer("org.openqa.selenium.grid.sessionqueue.remote.RemoteNewSessionQueuer");
        return new LocalDistributor(tracer, bus, clientFactory, sessions, sessionRequests, secretOptions.getRegistrationSecret(), distributorOptions.getHealthCheckInterval());
    }

    @Override
    public boolean isReady() {
        try {
            return ImmutableSet.of((Object)this.bus, (Object)this.sessions).parallelStream().map(HasReadyState::isReady).reduce(true, Boolean::logicalAnd);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(NodeStatus status) {
        Require.nonNull((String)"Node", (Object)status);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            if (this.nodes.containsKey(status.getId())) {
                return;
            }
            Set capabilities = (Set)status.getSlots().stream().map(Slot::getStereotype).map(ImmutableCapabilities::copyOf).collect(ImmutableSet.toImmutableSet());
            RemoteNode remoteNode = new RemoteNode(this.tracer, this.clientFactory, status.getId(), status.getUri(), this.registrationSecret, capabilities);
            this.add(remoteNode);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public LocalDistributor add(Node node) {
        Require.nonNull((String)"Node", (Object)node);
        LOG.info(String.format("Added node %s at %s.", node.getId(), node.getUri()));
        this.nodes.put(node.getId(), node);
        this.model.add(node.getStatus());
        Runnable runnableHealthCheck = this.asRunnableHealthCheck(node);
        this.allChecks.put(node.getId(), runnableHealthCheck);
        this.hostChecker.submit(runnableHealthCheck, this.healthcheckInterval, Duration.ofSeconds(30L));
        this.bus.fire(new NodeAddedEvent(node.getId()));
        return this;
    }

    private Runnable asRunnableHealthCheck(Node node) {
        HealthCheck healthCheck = node.getHealthCheck();
        NodeId id = node.getId();
        return () -> {
            HealthCheck.Result result;
            try {
                result = healthCheck.check();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Unable to process node " + id, e);
                result = new HealthCheck.Result(Availability.DOWN, "Unable to run healthcheck. Assuming down");
            }
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                this.model.setAvailability(id, result.getAvailability());
            }
            finally {
                writeLock.unlock();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drain(NodeId nodeId) {
        Node node = this.nodes.get(nodeId);
        if (node == null) {
            LOG.info("Asked to drain unregistered node " + nodeId);
            return false;
        }
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            node.drain();
            this.model.setAvailability(nodeId, Availability.DRAINING);
        }
        finally {
            writeLock.unlock();
        }
        return node.isDraining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(NodeId nodeId) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.model.remove(nodeId);
            Runnable runnable = this.allChecks.remove(nodeId);
            if (runnable != null) {
                this.hostChecker.remove(runnable);
            }
        }
        finally {
            writeLock.unlock();
            this.bus.fire(new NodeRemovedEvent(nodeId));
        }
    }

    @Override
    public DistributorStatus getStatus() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            DistributorStatus distributorStatus = new DistributorStatus(this.model.getSnapshot());
            return distributorStatus;
        }
        finally {
            readLock.unlock();
        }
    }

    @Beta
    public void refresh() {
        ArrayList<Runnable> allHealthChecks = new ArrayList<Runnable>();
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            allHealthChecks.addAll(this.allChecks.values());
        }
        finally {
            readLock.unlock();
        }
        allHealthChecks.parallelStream().forEach(Runnable::run);
    }

    @Override
    protected Set<NodeStatus> getAvailableNodes() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Set set = (Set)this.model.getSnapshot().stream().filter(node -> !Availability.DOWN.equals((Object)node.getAvailability())).collect(ImmutableSet.toImmutableSet());
            return set;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Either<SessionNotCreatedException, CreateSessionResponse> reserve(SlotId slotId, CreateSessionRequest request) {
        Require.nonNull((String)"Slot ID", (Object)slotId);
        Require.nonNull((String)"New Session request", (Object)request);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            Node node = this.nodes.get(slotId.getOwningNodeId());
            if (node == null) {
                Either either = Either.left((Object)new RetrySessionRequestException("Unable to find node. Try a different node"));
                return either;
            }
            this.model.reserve(slotId);
            Either<WebDriverException, CreateSessionResponse> response = node.newSession(request);
            if (response.isRight()) {
                this.model.setSession(slotId, ((CreateSessionResponse)response.right()).getSession());
                Either either = Either.right((Object)((CreateSessionResponse)response.right()));
                return either;
            }
            this.model.setSession(slotId, null);
            WebDriverException exception = (WebDriverException)response.left();
            if (exception instanceof RetrySessionRequestException) {
                Either either = Either.left((Object)new RetrySessionRequestException(exception.getMessage()));
                return either;
            }
            Either either = Either.left((Object)((Object)new SessionNotCreatedException(exception.getMessage())));
            return either;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void callExecutorShutdown() {
        LOG.info("Shutting down Distributor executor service");
        this.executorService.shutdownNow();
    }

    public class NewSessionRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Lock writeLock = LocalDistributor.this.lock.writeLock();
            writeLock.lock();
            try {
                RequestId reqId;
                ImmutableSet availableNodes;
                boolean hasCapacity;
                if (!LocalDistributor.this.requestIds.isEmpty() && (hasCapacity = (availableNodes = ImmutableSet.copyOf(LocalDistributor.this.getAvailableNodes())).stream().anyMatch(NodeStatus::hasCapacity)) && (reqId = (RequestId)LocalDistributor.this.requestIds.poll()) != null) {
                    Optional<HttpRequest> optionalHttpRequest = LocalDistributor.this.sessionRequests.remove(reqId);
                    if (optionalHttpRequest.isPresent()) {
                        this.handleNewSessionRequest(optionalHttpRequest.get(), reqId);
                    } else {
                        this.fireSessionRejectedEvent("Unable to poll request from the new session request queue.", reqId);
                    }
                }
            }
            finally {
                writeLock.unlock();
            }
        }

        private void handleNewSessionRequest(HttpRequest sessionRequest, RequestId reqId) {
            try (Span span = HttpTracing.newSpanAsChildOf((Tracer)LocalDistributor.this.tracer, (HttpRequest)sessionRequest, (String)"distributor.poll_queue");){
                HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
                attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
                span.setAttribute(AttributeKey.REQUEST_ID.getKey(), reqId.toString());
                attributeMap.put(AttributeKey.REQUEST_ID.getKey(), EventAttribute.setValue((String)reqId.toString()));
                attributeMap.put("request", EventAttribute.setValue((String)sessionRequest.toString()));
                Either<SessionNotCreatedException, CreateSessionResponse> response = LocalDistributor.this.newSession(sessionRequest);
                if (response.isRight()) {
                    CreateSessionResponse sessionResponse = (CreateSessionResponse)response.right();
                    NewSessionResponse newSessionResponse = new NewSessionResponse(reqId, sessionResponse.getSession(), sessionResponse.getDownstreamEncodedResponse());
                    LocalDistributor.this.bus.fire(new NewSessionResponseEvent(newSessionResponse));
                } else {
                    SessionNotCreatedException exception = (SessionNotCreatedException)((Object)response.left());
                    if (exception instanceof RetrySessionRequestException) {
                        boolean retried = LocalDistributor.this.sessionRequests.retryAddToQueue(sessionRequest, reqId);
                        attributeMap.put("request.retry_add", EventAttribute.setValue((boolean)retried));
                        span.addEvent("Retry adding to front of queue. No slot available.", attributeMap);
                        if (!retried) {
                            span.addEvent("Retry adding to front of queue failed.", attributeMap);
                            this.fireSessionRejectedEvent(exception.getMessage(), reqId);
                        }
                    } else {
                        this.fireSessionRejectedEvent(exception.getMessage(), reqId);
                    }
                }
            }
        }

        private void fireSessionRejectedEvent(String message, RequestId reqId) {
            LocalDistributor.this.bus.fire(new NewSessionRejectedEvent(new NewSessionErrorResponse(reqId, message)));
        }
    }
}

