/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.config;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.openqa.selenium.grid.config.ConfigValue;
import org.openqa.selenium.grid.config.HasRoles;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;

@AutoService(value={HasRoles.class})
public class DistributorFlags
implements HasRoles {
    @Parameter(names={"-d", "--distributor"}, description="Url of the distributor.")
    @ConfigValue(section="distributor", name="host", example="\"http://localhost:5553\"")
    private URI distributorServer;
    @Parameter(names={"--distributor-port"}, description="Port on which the distributor is listening.")
    @ConfigValue(section="distributor", name="port", example="5553")
    private Integer distributorServerPort;
    @Parameter(names={"--distributor-host"}, description="Host on which the distributor is listening.")
    @ConfigValue(section="distributor", name="hostname", example="\"localhost\"")
    private String distributorServerHost;
    @Parameter(names={"--distributor-implementation"}, description="Full classname of non-default distributor implementation")
    @ConfigValue(section="distributor", name="implementation", example="org.openqa.selenium.grid.distributor.local.LocalDistributor")
    private String implementation = "org.openqa.selenium.grid.distributor.local.LocalDistributor";
    @Parameter(names={"--healthcheck-interval"}, description="How often, in seconds, will the health check run for all Nodes.This ensures the server can ping all the Nodes successfully.")
    @ConfigValue(section="distributor", name="healthcheck-interval", example="60")
    public int healthcheckInterval = 300;

    @Override
    public Set<Role> getRoles() {
        return Collections.singleton(StandardGridRoles.DISTRIBUTOR_ROLE);
    }
}

