/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.local;

import java.io.IOException;
import java.io.Reader;
import java.time.Duration;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.NewSessionErrorResponse;
import org.openqa.selenium.grid.data.NewSessionRejectedEvent;
import org.openqa.selenium.grid.data.NewSessionRequestEvent;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.jmx.JMXHelper;
import org.openqa.selenium.grid.jmx.ManagedAttribute;
import org.openqa.selenium.grid.jmx.ManagedService;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.grid.sessionqueue.local.SessionRequest;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tracer;

@ManagedService(objectName="org.seleniumhq.grid:type=SessionQueue,name=LocalSessionQueue", description="New session queue")
public class LocalNewSessionQueue
extends NewSessionQueue {
    private static final Logger LOG = Logger.getLogger(LocalNewSessionQueue.class.getName());
    private final EventBus bus;
    private final Deque<SessionRequest> sessionRequests = new ConcurrentLinkedDeque<SessionRequest>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final Thread shutdownHook = new Thread(this::callExecutorShutdown);

    public LocalNewSessionQueue(Tracer tracer, EventBus bus, Duration retryInterval, Duration requestTimeout) {
        super(tracer, retryInterval, requestTimeout);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        new JMXHelper().register(this);
    }

    public static NewSessionQueue create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        Duration retryInterval = new NewSessionQueueOptions(config).getSessionRequestRetryInterval();
        Duration requestTimeout = new NewSessionQueueOptions(config).getSessionRequestTimeout();
        return new LocalNewSessionQueue(tracer, bus, retryInterval, requestTimeout);
    }

    @Override
    public boolean isReady() {
        return this.bus.isReady();
    }

    @Override
    @ManagedAttribute(name="NewSessionQueueSize")
    public int getQueueSize() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            int n = this.sessionRequests.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public List<Object> getQueuedRequests() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List<Object> list = this.sessionRequests.stream().map(SessionRequest::getHttpRequest).map(req -> {
                try (Reader reader = Contents.reader((HttpMessage)req);){
                    Iterator iterator;
                    block14: {
                        NewSessionPayload payload = NewSessionPayload.create((Reader)reader);
                        try {
                            iterator = payload.stream().iterator();
                            if (payload == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (payload != null) {
                                try {
                                    payload.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        payload.close();
                    }
                    return iterator;
                }
                catch (IOException e) {
                    LOG.warning("IOException while mapping to capabilities" + e.getMessage());
                    return null;
                }
            }).filter(Objects::nonNull).filter(Iterator::hasNext).map(Iterator::next).collect(Collectors.toList());
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(HttpRequest request, RequestId requestId) {
        Require.nonNull((String)"New Session request", (Object)request);
        Span span = this.tracer.getCurrentContext().createSpan("local_sessionqueue.add");
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            SessionRequest sessionRequest = new SessionRequest(requestId, request);
            this.addRequestHeaders(request, requestId);
            boolean added = this.sessionRequests.offerLast(sessionRequest);
            attributeMap.put(AttributeKey.REQUEST_ID.getKey(), EventAttribute.setValue((String)requestId.toString()));
            attributeMap.put("request.added", EventAttribute.setValue((boolean)added));
            span.addEvent("Add new session request to the queue", attributeMap);
            if (added) {
                this.bus.fire(new NewSessionRequestEvent(requestId));
            }
            boolean bl = added;
            return bl;
        }
        finally {
            writeLock.unlock();
            span.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(HttpRequest request, RequestId requestId) {
        Require.nonNull((String)"New Session request", (Object)request);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            SessionRequest sessionRequest = new SessionRequest(requestId, request);
            boolean added = this.sessionRequests.offerFirst(sessionRequest);
            if (added) {
                this.executorService.schedule(() -> this.retryRequest(sessionRequest), this.retryInterval.getSeconds(), TimeUnit.SECONDS);
            }
            boolean bl = added;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryRequest(SessionRequest sessionRequest) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            HttpRequest request = sessionRequest.getHttpRequest();
            RequestId requestId = sessionRequest.getRequestId();
            if (this.hasRequestTimedOut(request)) {
                LOG.log(Level.INFO, "Request {0} timed out", requestId);
                this.sessionRequests.remove(sessionRequest);
                this.bus.fire(new NewSessionRejectedEvent(new NewSessionErrorResponse(requestId, String.format("New session request rejected after being in the queue for more than %s", this.requestTimeout))));
            } else {
                LOG.log(Level.INFO, "Adding request back to the queue. All slots are busy. Request: {0}", requestId);
                this.bus.fire(new NewSessionRequestEvent(requestId));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<HttpRequest> remove(RequestId id) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            HttpRequest request;
            Optional<SessionRequest> firstSessionRequest = Optional.ofNullable(this.sessionRequests.peekFirst());
            Optional<HttpRequest> httpRequest = Optional.empty();
            if (firstSessionRequest.isPresent()) {
                if (id.equals(firstSessionRequest.get().getRequestId())) {
                    httpRequest = Optional.ofNullable(this.sessionRequests.pollFirst().getHttpRequest());
                } else {
                    Optional<SessionRequest> matchedRequest = this.sessionRequests.stream().filter(sessionRequest -> id.equals(sessionRequest.getRequestId())).findFirst();
                    if (matchedRequest.isPresent()) {
                        SessionRequest sessionRequest2 = matchedRequest.get();
                        this.sessionRequests.remove(sessionRequest2);
                        httpRequest = Optional.of(sessionRequest2.getHttpRequest());
                    }
                }
            }
            if (httpRequest.isPresent() && this.hasRequestTimedOut(request = (HttpRequest)httpRequest.get())) {
                this.bus.fire(new NewSessionRejectedEvent(new NewSessionErrorResponse(id, String.format("New session request rejected after being in the queue for more than %s", this.requestTimeout))));
                Optional<HttpRequest> optional = Optional.empty();
                return optional;
            }
            Optional<HttpRequest> optional = httpRequest;
            return optional;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clear() {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            int count = 0;
            LOG.info("Clearing new session request queue");
            SessionRequest sessionRequest = this.sessionRequests.poll();
            while (sessionRequest != null) {
                ++count;
                NewSessionErrorResponse errorResponse = new NewSessionErrorResponse(sessionRequest.getRequestId(), "New session request cancelled.");
                this.bus.fire(new NewSessionRejectedEvent(errorResponse));
                sessionRequest = this.sessionRequests.poll();
            }
            int n = count;
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void callExecutorShutdown() {
        LOG.info("Shutting down session queue executor service");
        this.executorService.shutdown();
    }
}

