/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.concurrent.Regularly;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.web.ReverseProxyHandler;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;

class HandleSession
implements HttpHandler {
    private final Tracer tracer;
    private final HttpClient.Factory httpClientFactory;
    private final SessionMap sessions;
    private final Cache<URL, HttpClient> httpClients;

    HandleSession(Tracer tracer, HttpClient.Factory httpClientFactory, SessionMap sessions) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.httpClientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client factory", (Object)httpClientFactory);
        this.sessions = (SessionMap)Require.nonNull((String)"Sessions", (Object)sessions);
        this.httpClients = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(1L)).removalListener(removal -> {
            try {
                ((HttpClient)removal.getValue()).close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).build();
        new Regularly("Clean up http clients cache").submit(() -> this.httpClients.cleanUp(), Duration.ofMinutes(1L), Duration.ofMinutes(1L));
    }

    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"router.handle_session");){
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            attributeMap.put(AttributeKey.HTTP_HANDLER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            Tags.HTTP_REQUEST.accept(span, req);
            Tags.HTTP_REQUEST_EVENT.accept(attributeMap, req);
            SessionId id = HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).orElseThrow(() -> {
                NoSuchSessionException exception = new NoSuchSessionException("Cannot find session: " + req);
                Tags.EXCEPTION.accept(attributeMap, exception);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to execute request for an existing session: " + exception.getMessage())));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                return exception;
            });
            RemoteTags.SESSION_ID.accept(span, id);
            RemoteTags.SESSION_ID_EVENT.accept(attributeMap, id);
            try {
                HttpTracing.inject((Tracer)this.tracer, (TraceContext)span, (HttpRequest)req);
                HttpResponse res = this.loadSessionId(this.tracer, span, id).call().execute(req);
                Tags.HTTP_RESPONSE.accept(span, res);
                HttpResponse httpResponse = res;
                return httpResponse;
            }
            catch (Exception e) {
                span.setAttribute("error", true);
                span.setStatus(Status.CANCELLED);
                Tags.EXCEPTION.accept(attributeMap, e);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to execute request for an existing session: " + e.getMessage())));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
    }

    private Callable<HttpHandler> loadSessionId(Tracer tracer, Span span, SessionId id) {
        return span.wrap(() -> {
            Session session = this.sessions.get(id);
            URL url = Urls.fromUri((URI)session.getUri());
            HttpClient client = (HttpClient)this.httpClients.get((Object)url, () -> this.httpClientFactory.createClient(url));
            return new ReverseProxyHandler(tracer, client);
        });
    }
}

