/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.openqa.selenium.grid.web.Resource;
import org.openqa.selenium.internal.Require;

public class PathResource
implements Resource {
    private final Path base;

    public PathResource(Path base) {
        this.base = ((Path)Require.nonNull((String)"Base path", (Object)base)).normalize();
    }

    @Override
    public String name() {
        return this.base.getFileName() == null ? "" : this.base.getFileName().toString();
    }

    @Override
    public Optional<Resource> get(String path) {
        Path normalized;
        if (path.startsWith("/")) {
            String string = path = path.length() == 1 ? "" : path.substring(1);
        }
        if (!(normalized = this.base.resolve(path).normalize()).startsWith(this.base)) {
            throw new RuntimeException("Attempt to navigate away from the parent directory");
        }
        if (Files.exists(normalized, new LinkOption[0])) {
            return Optional.of(new PathResource(normalized));
        }
        return Optional.empty();
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.base, new LinkOption[0]);
    }

    @Override
    public Set<Resource> list() {
        Set set;
        block8: {
            Stream<Path> files = Files.list(this.base);
            try {
                set = (Set)files.map(PathResource::new).collect(ImmutableSet.toImmutableSet());
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            files.close();
        }
        return set;
    }

    @Override
    public Optional<byte[]> read() {
        if (!Files.exists(this.base, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return Optional.of(Files.readAllBytes(this.base));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

