/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.local;

import java.time.Duration;
import java.util.Deque;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.NewSessionErrorResponse;
import org.openqa.selenium.grid.data.NewSessionRejectedEvent;
import org.openqa.selenium.grid.data.NewSessionRequestEvent;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.grid.sessionqueue.local.SessionRequest;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tracer;

public class LocalNewSessionQueue
extends NewSessionQueue {
    private static final Logger LOG = Logger.getLogger(LocalNewSessionQueue.class.getName());
    private final EventBus bus;
    private final Deque<SessionRequest> sessionRequests = new ConcurrentLinkedDeque<SessionRequest>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final Thread shutdownHook = new Thread(this::callExecutorShutdown);

    public LocalNewSessionQueue(Tracer tracer, EventBus bus, Duration retryInterval, Duration requestTimeout) {
        super(tracer, retryInterval, requestTimeout);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public static NewSessionQueue create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        Duration retryInterval = new NewSessionQueueOptions(config).getSessionRequestRetryInterval();
        Duration requestTimeout = new NewSessionQueueOptions(config).getSessionRequestTimeout();
        return new LocalNewSessionQueue(tracer, bus, retryInterval, requestTimeout);
    }

    @Override
    public boolean isReady() {
        return this.bus.isReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(HttpRequest request, RequestId requestId) {
        Require.nonNull((String)"New Session request", (Object)request);
        Span span = this.tracer.getCurrentContext().createSpan("local_sessionqueue.add");
        boolean added = false;
        SessionRequest sessionRequest = new SessionRequest(requestId, request);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            added = this.sessionRequests.offerLast(sessionRequest);
            this.addRequestHeaders(request, requestId);
            attributeMap.put(AttributeKey.REQUEST_ID.getKey(), EventAttribute.setValue((String)requestId.toString()));
            attributeMap.put("request.added", EventAttribute.setValue((boolean)added));
            span.addEvent("Add new session request to the queue", attributeMap);
            boolean bl = added;
            return bl;
        }
        finally {
            writeLock.unlock();
            span.close();
            if (added) {
                this.bus.fire(new NewSessionRequestEvent(requestId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(HttpRequest request, RequestId requestId) {
        Require.nonNull((String)"New Session request", (Object)request);
        boolean added = false;
        SessionRequest sessionRequest = new SessionRequest(requestId, request);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            boolean bl = added = this.sessionRequests.offerFirst(sessionRequest);
            return bl;
        }
        finally {
            writeLock.unlock();
            if (added) {
                this.executorService.schedule(() -> this.retryRequest(sessionRequest), this.retryInterval.getSeconds(), TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryRequest(SessionRequest sessionRequest) {
        HttpRequest request = sessionRequest.getHttpRequest();
        RequestId requestId = sessionRequest.getRequestId();
        if (this.hasRequestTimedOut(request)) {
            LOG.log(Level.INFO, "Request {0} timed out", requestId);
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                this.sessionRequests.remove(sessionRequest);
            }
            finally {
                writeLock.unlock();
                this.bus.fire(new NewSessionRejectedEvent(new NewSessionErrorResponse(requestId, "New session request timed out")));
            }
        } else {
            LOG.log(Level.INFO, "Adding request back to the queue. All slots are busy. Request: {0}", requestId);
            this.bus.fire(new NewSessionRequestEvent(requestId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<HttpRequest> remove(RequestId id) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            Optional<Object> optional;
            Optional<SessionRequest> firstSessionRequest = Optional.ofNullable(this.sessionRequests.peekFirst());
            Optional<HttpRequest> httpRequest = Optional.empty();
            if (firstSessionRequest.isPresent()) {
                if (id.equals(firstSessionRequest.get().getRequestId())) {
                    httpRequest = Optional.ofNullable(this.sessionRequests.pollFirst().getHttpRequest());
                } else {
                    Optional<SessionRequest> matchedRequest = this.sessionRequests.stream().filter(sessionRequest -> id.equals(sessionRequest.getRequestId())).findFirst();
                    if (matchedRequest.isPresent()) {
                        SessionRequest sessionRequest2 = matchedRequest.get();
                        this.sessionRequests.remove(sessionRequest2);
                        httpRequest = Optional.of(sessionRequest2.getHttpRequest());
                    }
                }
            }
            if (httpRequest.isPresent() && this.hasRequestTimedOut((HttpRequest)httpRequest.get())) {
                this.bus.fire(new NewSessionRejectedEvent(new NewSessionErrorResponse(id, "New session request timed out")));
                optional = Optional.empty();
                return optional;
            }
            optional = httpRequest;
            return optional;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clear() {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            int count = 0;
            LOG.info("Clearing new session request queue");
            SessionRequest sessionRequest = this.sessionRequests.poll();
            while (sessionRequest != null) {
                ++count;
                NewSessionErrorResponse errorResponse = new NewSessionErrorResponse(sessionRequest.getRequestId(), "New session request cancelled.");
                this.bus.fire(new NewSessionRejectedEvent(errorResponse));
                sessionRequest = this.sessionRequests.poll();
            }
            int n = count;
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void callExecutorShutdown() {
        LOG.info("Shutting down session queue executor service");
        this.executorService.shutdown();
    }
}

