/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.config;

import java.time.Duration;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;

public class NewSessionQueueOptions {
    private static final String SESSIONS_QUEUE_SECTION = "sessionqueue";
    private static final String DEFAULT_NEWSESSION_QUEUE = "org.openqa.selenium.grid.sessionmap.remote.LocalNewSessionQueue";
    private static final int DEFAULT_REQUEST_TIMEOUT = 300;
    private static final int DEFAULT_RETRY_INTERVAL = 5;
    private final Config config;

    public NewSessionQueueOptions(Config config) {
        this.config = config;
    }

    public Duration getSessionRequestTimeout() {
        int timeout = this.config.getInt(SESSIONS_QUEUE_SECTION, "session-request-timeout").orElse(300);
        if (timeout <= 0) {
            return Duration.ofSeconds(300L);
        }
        return Duration.ofSeconds(timeout);
    }

    public Duration getSessionRequestRetryInterval() {
        int interval = this.config.getInt(SESSIONS_QUEUE_SECTION, "session-retry-interval").orElse(5);
        if (interval <= 0) {
            return Duration.ofSeconds(5L);
        }
        return Duration.ofSeconds(interval);
    }

    public NewSessionQueue getSessionQueue() {
        return this.config.getClass(SESSIONS_QUEUE_SECTION, "implementation", NewSessionQueue.class, DEFAULT_NEWSESSION_QUEUE);
    }
}

