/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.data.NewSessionErrorResponse;
import org.openqa.selenium.grid.data.NewSessionRejectedEvent;
import org.openqa.selenium.grid.data.NewSessionRequest;
import org.openqa.selenium.grid.data.NewSessionResponse;
import org.openqa.selenium.grid.data.NewSessionResponseEvent;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.Tracer;

public class GetNewSessionResponse {
    private static final Logger LOG = Logger.getLogger(GetNewSessionResponse.class.getName());
    private final EventBus bus;
    private final Tracer tracer;
    private final NewSessionQueue sessionRequests;
    private final Map<RequestId, NewSessionRequest> knownRequests = new ConcurrentHashMap<RequestId, NewSessionRequest>();

    public GetNewSessionResponse(Tracer tracer, EventBus bus, NewSessionQueue sessionRequests) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        this.sessionRequests = (NewSessionQueue)Require.nonNull((String)"New Session Request Queue", (Object)sessionRequests);
        this.bus.addListener(NewSessionResponseEvent.listener(sessionResponse -> {
            try {
                this.setResponse((NewSessionResponse)sessionResponse);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        this.bus.addListener(NewSessionRejectedEvent.listener(sessionResponse -> {
            try {
                this.setErrorResponse((NewSessionErrorResponse)sessionResponse);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    private void setResponse(NewSessionResponse sessionResponse) {
        RequestId id = sessionResponse.getRequestId();
        Optional<NewSessionRequest> sessionRequest = Optional.ofNullable(this.knownRequests.get(id));
        if (sessionRequest.isPresent()) {
            NewSessionRequest request = sessionRequest.get();
            request.setSessionResponse((HttpResponse)new HttpResponse().setContent(Contents.bytes((byte[])sessionResponse.getDownstreamEncodedResponse())));
            request.getLatch().countDown();
        }
    }

    private void setErrorResponse(NewSessionErrorResponse sessionResponse) {
        RequestId id = sessionResponse.getRequestId();
        Optional<NewSessionRequest> sessionRequest = Optional.ofNullable(this.knownRequests.get(id));
        if (sessionRequest.isPresent()) {
            NewSessionRequest request = sessionRequest.get();
            request.setSessionResponse((HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.asJson((Object)ImmutableMap.of((Object)"message", (Object)sessionResponse.getMessage()))));
            request.getLatch().countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse add(HttpRequest request) {
        Require.nonNull((String)"New Session request", (Object)request);
        CountDownLatch latch = new CountDownLatch(1);
        UUID uuid = UUID.randomUUID();
        RequestId requestId = new RequestId(uuid);
        NewSessionRequest requestIdentifier = new NewSessionRequest(requestId, latch);
        this.knownRequests.put(requestId, requestIdentifier);
        if (!this.sessionRequests.offerLast(request, requestId)) {
            return (HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.asJson((Object)ImmutableMap.of((Object)"message", (Object)"Session request could not be created. Error while adding to the session queue.")));
        }
        try {
            HttpResponse res;
            latch.await();
            HttpResponse httpResponse = res = requestIdentifier.getSessionResponse();
            return httpResponse;
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "The thread waiting for new session response interrupted. {0}", e.getMessage());
            Thread.currentThread().interrupt();
            HttpResponse httpResponse = (HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.asJson((Object)ImmutableMap.of((Object)"message", (Object)"Session request could not be created. Error while processing the session request.")));
            return httpResponse;
        }
        finally {
            this.removeRequest(requestId);
        }
    }

    private void removeRequest(RequestId id) {
        this.knownRequests.remove(id);
    }
}

