/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.graphql.Node;
import org.openqa.selenium.internal.Require;

public class Grid {
    private final URI uri;
    private final Supplier<DistributorStatus> distributorStatus;

    public Grid(Distributor distributor, URI uri) {
        Require.nonNull((String)"Distributor", (Object)distributor);
        this.uri = (URI)Require.nonNull((String)"Grid's public URI", (Object)uri);
        this.distributorStatus = Suppliers.memoize(distributor::getStatus);
    }

    public URI getUri() {
        return this.uri;
    }

    public List<Node> getNodes() {
        ImmutableList.Builder toReturn = ImmutableList.builder();
        for (NodeStatus status : this.distributorStatus.get().getNodes()) {
            HashMap<Capabilities, Integer> capabilities = new HashMap<Capabilities, Integer>();
            HashMap<Session, Slot> sessions = new HashMap<Session, Slot>();
            for (Slot slot : status.getSlots()) {
                slot.getSession().ifPresent(session -> sessions.put((Session)session, slot));
                int count = capabilities.getOrDefault(slot.getStereotype(), 0);
                capabilities.put(slot.getStereotype(), ++count);
            }
            toReturn.add((Object)new Node(status.getId(), status.getUri(), status.getAvailability(), status.getMaxSessionCount(), capabilities, sessions));
        }
        return toReturn.build();
    }

    public int getSessionCount() {
        return this.distributorStatus.get().getNodes().stream().map(NodeStatus::getSlots).flatMap(Collection::stream).filter(slot -> slot.getSession().isPresent()).mapToInt(slot -> 1).sum();
    }

    public int getTotalSlots() {
        return this.distributorStatus.get().getNodes().stream().mapToInt(status -> {
            int slotCount = status.getSlots().size();
            return Math.min(status.getMaxSessionCount(), slotCount);
        }).sum();
    }

    public int getUsedSlots() {
        return this.getSessionCount();
    }
}

