/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.docker;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.docker.Container;
import org.openqa.selenium.docker.ContainerConfig;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.Docker;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.Port;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.docker.DockerSession;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.support.ui.FluentWait;

public class DockerSessionFactory
implements SessionFactory {
    private static final Logger LOG = Logger.getLogger(DockerSessionFactory.class.getName());
    private final Tracer tracer;
    private final HttpClient.Factory clientFactory;
    private final Docker docker;
    private final URI dockerUri;
    private final Image browserImage;
    private final Capabilities stereotype;
    private boolean isVideoRecordingAvailable;
    private Image videoImage;
    private String storagePath;

    public DockerSessionFactory(Tracer tracer, HttpClient.Factory clientFactory, Docker docker, URI dockerUri, Image browserImage, Capabilities stereotype) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.clientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client", (Object)clientFactory);
        this.docker = (Docker)Require.nonNull((String)"Docker command", (Object)docker);
        this.dockerUri = (URI)Require.nonNull((String)"Docker URI", (Object)dockerUri);
        this.browserImage = (Image)Require.nonNull((String)"Docker browser image", (Object)browserImage);
        this.stereotype = ImmutableCapabilities.copyOf((Capabilities)((Capabilities)Require.nonNull((String)"Stereotype", (Object)stereotype)));
        this.isVideoRecordingAvailable = false;
    }

    public DockerSessionFactory(Tracer tracer, HttpClient.Factory clientFactory, Docker docker, URI dockerUri, Image browserImage, Capabilities stereotype, Image videoImage, String storagePath) {
        this(tracer, clientFactory, docker, dockerUri, browserImage, stereotype);
        this.isVideoRecordingAvailable = true;
        this.videoImage = videoImage;
        this.storagePath = storagePath;
    }

    @Override
    public boolean test(Capabilities capabilities) {
        return this.stereotype.getCapabilityNames().stream().map(name -> Objects.equals(this.stereotype.getCapability(name), capabilities.getCapability(name))).reduce(Boolean::logicalAnd).orElse(false);
    }

    @Override
    public Optional<ActiveSession> apply(CreateSessionRequest sessionRequest) {
        LOG.info("Starting session for " + sessionRequest.getCapabilities());
        int port = PortProber.findFreePort();
        URL remoteAddress = this.getUrl(port);
        HttpClient client = this.clientFactory.createClient(remoteAddress);
        Span span = this.tracer.getCurrentContext().createSpan("docker_session_factory.apply");
        try {
            Response response;
            ProtocolHandshake.Result result;
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            LOG.info("Creating container, mapping container port 4444 to " + port);
            Map<String, String> browserContainerEnvVars = this.getBrowserContainerEnvVars(sessionRequest.getCapabilities());
            Container container = this.docker.create(ContainerConfig.image(this.browserImage).env(browserContainerEnvVars).map(Port.tcp(4444), Port.tcp(port)));
            container.start();
            ContainerInfo containerInfo = container.inspect();
            attributeMap.put("docker.browser.image", EventAttribute.setValue((String)this.browserImage.toString()));
            attributeMap.put("container.port", EventAttribute.setValue((long)port));
            attributeMap.put("container.id", EventAttribute.setValue((String)container.getId().toString()));
            attributeMap.put("container.ip", EventAttribute.setValue((String)containerInfo.getIp()));
            attributeMap.put("docker.server.url", EventAttribute.setValue((String)remoteAddress.toString()));
            LOG.info(String.format("Waiting for server to start (container id: %s)", container.getId()));
            try {
                this.waitForServerToStart(client, Duration.ofMinutes(1L));
            }
            catch (TimeoutException e) {
                span.setAttribute("error", true);
                span.setStatus(Status.CANCELLED);
                Tags.EXCEPTION.accept(attributeMap, e);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to connect to docker server. Stopping container: " + e.getMessage())));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                container.stop(Duration.ofMinutes(1L));
                container.delete();
                LOG.warning(String.format("Unable to connect to docker server (container id: %s)", container.getId()));
                Optional<ActiveSession> optional = Optional.empty();
                if (span != null) {
                    span.close();
                }
                return optional;
            }
            LOG.info(String.format("Server is ready (container id: %s)", container.getId()));
            Command command = new Command(null, DriverCommand.NEW_SESSION((Capabilities)sessionRequest.getCapabilities()));
            try {
                result = new ProtocolHandshake().createSession(client, command);
                response = result.createResponse();
                attributeMap.put(AttributeKey.DRIVER_RESPONSE.getKey(), EventAttribute.setValue((String)response.toString()));
            }
            catch (IOException | RuntimeException e) {
                span.setAttribute("error", true);
                span.setStatus(Status.CANCELLED);
                Tags.EXCEPTION.accept(attributeMap, e);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Unable to create session. Stopping and  container: " + e.getMessage())));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                container.stop(Duration.ofMinutes(1L));
                container.delete();
                LOG.log(Level.WARNING, "Unable to create session: " + e.getMessage(), e);
                Optional<ActiveSession> optional = Optional.empty();
                if (span != null) {
                    span.close();
                }
                return optional;
            }
            SessionId id = new SessionId(response.getSessionId());
            ImmutableCapabilities capabilities = new ImmutableCapabilities((Map)response.getValue());
            Container videoContainer = null;
            if (this.isVideoRecordingAvailable && this.recordVideoForSession(sessionRequest.getCapabilities())) {
                Map<String, String> envVars = this.getVideoContainerEnvVars(sessionRequest.getCapabilities(), containerInfo.getIp(), id.toString());
                Map<String, String> volumeBinds = Collections.singletonMap(this.storagePath, "/videos");
                videoContainer = this.docker.create(ContainerConfig.image(this.videoImage).env(envVars).bind(volumeBinds));
                videoContainer.start();
            }
            Dialect downstream = sessionRequest.getDownstreamDialects().contains(result.getDialect()) ? result.getDialect() : Dialect.W3C;
            attributeMap.put(AttributeKey.DOWNSTREAM_DIALECT.getKey(), EventAttribute.setValue((String)downstream.toString()));
            attributeMap.put(AttributeKey.DRIVER_RESPONSE.getKey(), EventAttribute.setValue((String)response.toString()));
            span.addEvent("Docker driver service created session", attributeMap);
            LOG.fine(String.format("Created session: %s - %s (container id: %s)", id, capabilities, container.getId()));
            Optional<ActiveSession> optional = Optional.of(new DockerSession(container, videoContainer, this.tracer, client, id, remoteAddress, this.stereotype, (Capabilities)capabilities, downstream, result.getDialect(), Instant.now()));
            return optional;
        }
        finally {
            if (span != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private Map<String, String> getBrowserContainerEnvVars(Capabilities sessionRequestCapabilities) {
        Optional<Dimension> screenResolution = Optional.ofNullable(this.getScreenResolution(sessionRequestCapabilities));
        HashMap<String, String> envVars = new HashMap<String, String>();
        if (screenResolution.isPresent()) {
            envVars.put("SCREEN_WIDTH", String.valueOf(screenResolution.get().getWidth()));
            envVars.put("SCREEN_HEIGHT", String.valueOf(screenResolution.get().getHeight()));
        }
        Optional<TimeZone> timeZone = Optional.ofNullable(this.getTimeZone(sessionRequestCapabilities));
        timeZone.ifPresent(zone -> envVars.put("TZ", zone.getID()));
        return envVars;
    }

    private Map<String, String> getVideoContainerEnvVars(Capabilities sessionRequestCapabilities, String containerIp, String fileName) {
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.put("DISPLAY_CONTAINER_NAME", containerIp);
        envVars.put("FILE_NAME", String.format("%s.mp4", fileName));
        Optional<Dimension> screenResolution = Optional.ofNullable(this.getScreenResolution(sessionRequestCapabilities));
        screenResolution.ifPresent(dimension -> envVars.put("VIDEO_SIZE", String.format("%sx%s", dimension.getWidth(), dimension.getHeight())));
        return envVars;
    }

    private TimeZone getTimeZone(Capabilities sessionRequestCapabilities) {
        Optional<Object> timeZone = Optional.ofNullable(this.getCapability(sessionRequestCapabilities, "timeZone"));
        if (timeZone.isPresent()) {
            String tz = timeZone.get().toString();
            if (Arrays.asList(TimeZone.getAvailableIDs()).contains(tz)) {
                return TimeZone.getTimeZone(tz);
            }
        }
        return null;
    }

    private Dimension getScreenResolution(Capabilities sessionRequestCapabilities) {
        Optional<Object> screenResolution = Optional.ofNullable(this.getCapability(sessionRequestCapabilities, "screenResolution"));
        if (screenResolution.isEmpty()) {
            return null;
        }
        try {
            String[] resolution = screenResolution.get().toString().split("x");
            int screenWidth = Integer.parseInt(resolution[0]);
            int screenHeight = Integer.parseInt(resolution[1]);
            if (screenWidth > 0 && screenHeight > 0) {
                return new Dimension(screenWidth, screenHeight);
            }
            LOG.warning("One of the values provided for screenResolution is negative, defaults will be used. Received value: " + screenResolution);
        }
        catch (Exception e) {
            LOG.warning("Values provided for screenResolution are not valid integers or either width or height are missing, defaults will be used.Received value: " + screenResolution);
        }
        return null;
    }

    private boolean recordVideoForSession(Capabilities sessionRequestCapabilities) {
        Optional<Object> recordVideo = Optional.ofNullable(this.getCapability(sessionRequestCapabilities, "recordVideo"));
        return recordVideo.isPresent() && Boolean.parseBoolean(recordVideo.get().toString());
    }

    private Object getCapability(Capabilities sessionRequestCapabilities, String capabilityName) {
        Object rawSeleniumOptions = sessionRequestCapabilities.getCapability("se:options");
        if (rawSeleniumOptions instanceof Map) {
            Map seleniumOptions = (Map)rawSeleniumOptions;
            return seleniumOptions.get(capabilityName);
        }
        return null;
    }

    private void waitForServerToStart(HttpClient client, Duration duration) {
        FluentWait wait = new FluentWait(new Object()).withTimeout(duration).ignoring(UncheckedIOException.class);
        wait.until(obj -> {
            HttpResponse response = client.execute(new HttpRequest(HttpMethod.GET, "/status"));
            LOG.fine(Contents.string((HttpMessage)response));
            return 200 == response.getStatus();
        });
    }

    private URL getUrl(int port) {
        try {
            String host = "localhost";
            if (this.dockerUri.getScheme().startsWith("tcp") || this.dockerUri.getScheme().startsWith("http")) {
                host = this.dockerUri.getHost();
            }
            return new URL(String.format("http://%s:%s/wd/hub", host, port));
        }
        catch (MalformedURLException e) {
            throw new SessionNotCreatedException(e.getMessage(), (Throwable)e);
        }
    }
}

