/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.docker;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.grid.config.ConfigValue;
import org.openqa.selenium.grid.config.HasRoles;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;

@AutoService(value={HasRoles.class})
public class DockerFlags
implements HasRoles {
    @Parameter(names={"--docker-url"}, description="URL for connecting to the docker daemon")
    @ConfigValue(section="docker", name="url", example="\"unix:/var/run/docker\"")
    private URL dockerUrl;
    @Parameter(names={"--docker-host"}, description="Host name where the docker daemon is running")
    @ConfigValue(section="docker", name="host", example="\"tcp://localhost:2375\"")
    private String dockerHost;
    @Parameter(names={"--docker", "-D"}, description="Docker configs which map image name to stereotype capabilities (example `-D selenium/standalone-firefox:latest '{\"browserName\": \"firefox\"}')", arity=2, variableArity=true)
    @ConfigValue(section="docker", name="configs", example="[\"selenium/standalone-firefox:latest\", \"{\\\"browserName\\\": \\\"firefox\\\"}\"]")
    private List<String> images2Capabilities;
    @Parameter(names={"--docker-video-image"}, description="Docker image to be used when video recording is enabled")
    @ConfigValue(section="docker", name="video-image", example="\"selenium/video:ffmpeg-4.3.1-20201030\"")
    private String videoImage;
    @Parameter(names={"--docker-video-path"}, description="Absolute path where videos will be stored")
    @ConfigValue(section="docker", name="video-path", example="\"/absolute/path/to/video/storage\"")
    private String videoPath;

    @Override
    public Set<Role> getRoles() {
        return Collections.singleton(StandardGridRoles.NODE_ROLE);
    }
}

