/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.selector;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.distributor.selector.SlotSelector;

public class DefaultSlotSelector
implements SlotSelector {
    private static final Logger LOG = Logger.getLogger(DefaultSlotSelector.class.getName());

    @Override
    public Set<SlotId> selectSlot(Capabilities capabilities, Set<NodeStatus> nodes) {
        Stream<NodeStatus> firstRound = nodes.stream().filter(node -> node.hasCapacity(capabilities));
        Stream<NodeStatus> prioritizedNodes = this.getPrioritizedNodeStream(firstRound, capabilities);
        return (Set)prioritizedNodes.sorted(Comparator.comparingDouble(NodeStatus::getLoad).thenComparingLong(NodeStatus::getLastSessionCreated).thenComparing(NodeStatus::getId)).flatMap(node -> node.getSlots().stream().filter(slot -> !slot.getSession().isPresent()).filter(slot -> slot.isSupporting(capabilities)).map(Slot::getId)).collect(ImmutableSet.toImmutableSet());
    }

    @VisibleForTesting
    Stream<NodeStatus> getPrioritizedNodeStream(Stream<NodeStatus> nodes, Capabilities capabilities) {
        Set<NodeStatus> filteredNodeSet = nodes.collect(Collectors.toSet());
        Map<String, Set<NodeStatus>> nodeBuckets = this.sortNodesToBucketsByBrowser(filteredNodeSet);
        if (this.allBucketsSameSize(nodeBuckets)) {
            return nodeBuckets.values().stream().distinct().flatMap(Collection::stream);
        }
        List sorted = nodeBuckets.entrySet().stream().sorted(Comparator.comparingInt(v -> ((Set)v.getValue()).size())).collect(Collectors.toList());
        for (Map.Entry entry : sorted) {
            Set<NodeStatus> filteredNodes;
            Map<String, Set<NodeStatus>> newNodeBuckets;
            if (((String)entry.getKey()).equals(capabilities.getBrowserName()) || !this.allBucketsSameSize(newNodeBuckets = this.sortNodesToBucketsByBrowser(filteredNodes = filteredNodeSet.stream().filter(node -> !((Set)entry.getValue()).contains(node)).collect(Collectors.toSet())))) continue;
            LOG.fine("Nodes have been balanced according to browser priority");
            return newNodeBuckets.values().stream().distinct().flatMap(Collection::stream);
        }
        return nodeBuckets.values().stream().distinct().flatMap(Collection::stream);
    }

    Map<String, Set<NodeStatus>> sortNodesToBucketsByBrowser(Set<NodeStatus> nodes) {
        HashMap<String, Set<NodeStatus>> buckets = new HashMap<String, Set<NodeStatus>>();
        for (NodeStatus node : nodes) {
            for (Slot slot : node.getSlots()) {
                String name = Optional.ofNullable(slot.getStereotype().getBrowserName()).orElse("");
                buckets.computeIfAbsent(name, n -> new LinkedHashSet()).add(node);
            }
        }
        return buckets;
    }

    @VisibleForTesting
    boolean allBucketsSameSize(Map<String, Set<NodeStatus>> buckets) {
        HashSet intSet = new HashSet();
        buckets.values().forEach(bucket -> intSet.add(bucket.size()));
        return intSet.size() == 1;
    }
}

