/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.distributor.Distributor;

public class DistributorOptions {
    private static final String DISTRIBUTOR_SECTION = "distributor";
    private static final Logger LOG = Logger.getLogger(DistributorOptions.class.getName());
    private final Config config;

    public DistributorOptions(Config config) {
        this.config = config;
    }

    public URI getDistributorUri() {
        Optional<URI> host = this.config.get(DISTRIBUTOR_SECTION, "host").map(str -> {
            try {
                return new URI((String)str);
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Distributor URI is not a valid URI: " + str, new Object[0]);
            }
        });
        if (host.isPresent()) {
            return host.get();
        }
        Optional<Integer> port = this.config.getInt(DISTRIBUTOR_SECTION, "port");
        Optional<String> hostname = this.config.get(DISTRIBUTOR_SECTION, "hostname");
        if (!port.isPresent() || !hostname.isPresent()) {
            throw new ConfigException("Unable to determine host and port for the distributor", new Object[0]);
        }
        try {
            return new URI("http", null, hostname.get(), port.get(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Distributor uri configured through host (%s) and port (%d) is not a valid URI", hostname.get(), port.get());
        }
    }

    public Distributor getDistributor(String defaultClass) {
        return this.config.getClass(DISTRIBUTOR_SECTION, "implementation", Distributor.class, defaultClass);
    }
}

