/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.events.zeromq;

import com.google.common.collect.EvictingQueue;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.openqa.selenium.events.Event;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.events.EventListener;
import org.openqa.selenium.events.EventName;
import org.openqa.selenium.events.zeromq.ZeroMqEventBus;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

class UnboundZmqEventBus
implements EventBus {
    static final EventName REJECTED_EVENT = new EventName("selenium-rejected-event");
    private static final Logger LOG = Logger.getLogger(EventBus.class.getName());
    private static final Json JSON = new Json();
    private final ExecutorService executor;
    private final Map<EventName, List<Consumer<Event>>> listeners = new ConcurrentHashMap<EventName, List<Consumer<Event>>>();
    private final Queue<UUID> recentMessages = EvictingQueue.create((int)128);
    private final String encodedSecret;
    private ZMQ.Socket pub;
    private ZMQ.Socket sub;

    UnboundZmqEventBus(ZContext context, String publishConnection, String subscribeConnection, Secret secret) {
        Require.nonNull((String)"Secret", (Object)secret);
        StringBuilder builder = new StringBuilder();
        try (JsonOutput out = JSON.newOutput((Appendable)builder);){
            out.setPrettyPrint(false).writeClassName(false).write((Object)secret);
        }
        this.encodedSecret = builder.toString();
        this.executor = Executors.newCachedThreadPool(r -> {
            Thread thread = new Thread(r);
            thread.setName("Event Bus");
            thread.setDaemon(true);
            return thread;
        });
        String connectionMessage = String.format("Connecting to %s and %s", publishConnection, subscribeConnection);
        LOG.info(connectionMessage);
        RetryPolicy retryPolicy = new RetryPolicy().withMaxAttempts(5).withDelay(5L, 10L, ChronoUnit.SECONDS).onFailedAttempt(e -> LOG.log(Level.WARNING, String.format("%s failed", connectionMessage))).onRetry(e -> LOG.log(Level.WARNING, String.format("Failure #%s. Retrying.", e.getAttemptCount()))).onRetriesExceeded(e -> LOG.log(Level.WARNING, "Connection aborted."));
        Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).run(() -> {
            this.sub = context.createSocket(SocketType.SUB);
            this.sub.setIPv6(this.isSubAddressIPv6(publishConnection));
            this.sub.connect(publishConnection);
            this.sub.subscribe(new byte[0]);
            this.pub = context.createSocket(SocketType.PUB);
            this.pub.setIPv6(this.isSubAddressIPv6(subscribeConnection));
            this.pub.connect(subscribeConnection);
        });
        ZMQ.Poller poller = context.createPoller(1);
        poller.register(Objects.requireNonNull(this.sub), 1);
        LOG.info("Sockets created");
        AtomicBoolean pollingStarted = new AtomicBoolean(false);
        this.executor.submit(() -> {
            LOG.info("Bus started");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    poller.poll(150L);
                    pollingStarted.lazySet(true);
                    if (!poller.pollin(0)) continue;
                    ZMQ.Socket socket = poller.getSocket(0);
                    EventName eventName = new EventName(new String(socket.recv(1), StandardCharsets.UTF_8));
                    Secret eventSecret = (Secret)JSON.toType(new String(socket.recv(1), StandardCharsets.UTF_8), Secret.class);
                    UUID id = UUID.fromString(new String(socket.recv(1), StandardCharsets.UTF_8));
                    String data = new String(socket.recv(1), StandardCharsets.UTF_8);
                    Object converted = JSON.toType(data, Object.class);
                    Event event = new Event(id, eventName, converted);
                    if (this.recentMessages.contains(id)) continue;
                    this.recentMessages.add(id);
                    if (!Secret.matches(secret, eventSecret)) {
                        LOG.severe(String.format("Received message without a valid secret. Rejecting. %s -> %s", event, data));
                        Event rejectedEvent = new Event(REJECTED_EVENT, new ZeroMqEventBus.RejectedEvent(eventName, data));
                        ((List)this.listeners.getOrDefault(REJECTED_EVENT, new ArrayList())).forEach(listener -> listener.accept(rejectedEvent));
                        return;
                    }
                    List<Consumer<Event>> typeListeners = this.listeners.get(eventName);
                    if (typeListeners == null) continue;
                    typeListeners.parallelStream().forEach(listener -> listener.accept(event));
                }
                catch (Throwable e) {
                    if (e.getCause() != null && e.getCause() instanceof AssertionError) continue;
                    throw e;
                }
            }
        });
        while (!pollingStarted.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e2);
            }
        }
    }

    @Override
    public boolean isReady() {
        return !this.executor.isShutdown();
    }

    private boolean isSubAddressIPv6(String connection) {
        try {
            URI uri = new URI(connection);
            if ("inproc".equals(uri.getScheme())) {
                return false;
            }
            return InetAddress.getByName(uri.getHost()) instanceof Inet6Address;
        }
        catch (URISyntaxException | UnknownHostException e) {
            LOG.log(Level.WARNING, String.format("Could not determine if the address %s is IPv6 or IPv4", connection), e);
            return false;
        }
    }

    @Override
    public void addListener(EventListener<?> listener) {
        Require.nonNull((String)"Listener", listener);
        List typeListeners = this.listeners.computeIfAbsent(listener.getEventName(), t -> new LinkedList());
        typeListeners.add(listener);
    }

    @Override
    public void fire(Event event) {
        Require.nonNull((String)"Event to send", (Object)event);
        this.pub.sendMore(event.getType().getName().getBytes(StandardCharsets.UTF_8));
        this.pub.sendMore(this.encodedSecret.getBytes(StandardCharsets.UTF_8));
        this.pub.sendMore(event.getId().toString().getBytes(StandardCharsets.UTF_8));
        this.pub.send(event.getRawData().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void close() {
        this.executor.shutdown();
        if (this.sub != null) {
            this.sub.close();
        }
        if (this.pub != null) {
            this.pub.close();
        }
    }
}

