/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.Beta;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.Port;
import org.openqa.selenium.internal.Require;

@Beta
public class ContainerConfig {
    private final Image image;
    private final Multimap<String, Map<String, Object>> portBindings;
    private final Map<String, String> envVars;
    private final Map<String, String> volumeBinds;

    public ContainerConfig(Image image, Multimap<String, Map<String, Object>> portBindings, Map<String, String> envVars, Map<String, String> volumeBinds) {
        this.image = image;
        this.portBindings = portBindings;
        this.envVars = envVars;
        this.volumeBinds = volumeBinds;
    }

    public static ContainerConfig image(Image image) {
        return new ContainerConfig(image, (Multimap<String, Map<String, Object>>)HashMultimap.create(), (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of());
    }

    public ContainerConfig map(Port containerPort, Port hostPort) {
        Require.nonNull((String)"Container port", (Object)containerPort);
        Require.nonNull((String)"Host port", (Object)hostPort);
        if (!hostPort.getProtocol().equals(containerPort.getProtocol())) {
            throw new DockerException(String.format("Port protocols must match: %s -> %s", hostPort, containerPort));
        }
        HashMultimap updatedBindings = HashMultimap.create(this.portBindings);
        updatedBindings.put((Object)(containerPort.getPort() + "/" + containerPort.getProtocol()), (Object)ImmutableMap.of((Object)"HostPort", (Object)String.valueOf(hostPort.getPort()), (Object)"HostIp", (Object)""));
        return new ContainerConfig(this.image, (Multimap<String, Map<String, Object>>)updatedBindings, this.envVars, this.volumeBinds);
    }

    public ContainerConfig env(Map<String, String> envVars) {
        Require.nonNull((String)"Container env vars", envVars);
        return new ContainerConfig(this.image, this.portBindings, envVars, this.volumeBinds);
    }

    public ContainerConfig bind(Map<String, String> volumeBinds) {
        Require.nonNull((String)"Container volume binds", volumeBinds);
        return new ContainerConfig(this.image, this.portBindings, this.envVars, volumeBinds);
    }

    public String toString() {
        return "ContainerConfig{image=" + this.image + ", portBindings=" + this.portBindings + ", envVars=" + this.envVars + ", volumeBinds=" + this.volumeBinds + '}';
    }

    private Map<String, Object> toJson() {
        List envVars = this.envVars.keySet().stream().map(key -> String.format("%s=%s", key, this.envVars.get(key))).collect(Collectors.toList());
        List volumeBinds = this.volumeBinds.keySet().stream().map(key -> String.format("%s:%s", key, this.volumeBinds.get(key))).collect(Collectors.toList());
        ImmutableMap hostConfig = ImmutableMap.of((Object)"PortBindings", (Object)this.portBindings.asMap(), (Object)"Binds", volumeBinds);
        return ImmutableMap.of((Object)"Image", (Object)this.image.getId(), (Object)"Env", envVars, (Object)"HostConfig", (Object)hostConfig);
    }
}

