module org.seleniumhq.selenium.grid {
    requires failsafe;
    requires io.netty.buffer;
    requires io.netty.codec;
    requires io.netty.codec.http;
    requires io.netty.common;
    requires io.netty.handler;
    requires io.opentelemetry.api;
    requires io.opentelemetry.context.propagation;
    requires io.opentelemetry.sdk;
    requires io.opentelemetry.sdk.common;
    requires io.opentelemetry.sdk.trace;
    requires jtoml;
    requires org.seleniumhq.selenium.chromium_driver;
    requires org.seleniumhq.selenium.support;
    /* transitive */ requires com.google.common;
    /* transitive */ requires graphql.java;
    /* transitive */ requires io.netty.transport;
    /* transitive */ requires java.logging;
    /* transitive */ requires javax.servlet.api;
    /* transitive */ requires jcommander;
    /* transitive */ requires jeromq;
    /* transitive */ requires org.seleniumhq.selenium.api;
    /* transitive */ requires org.seleniumhq.selenium.http;
    /* transitive */ requires org.seleniumhq.selenium.json;
    /* transitive */ requires org.seleniumhq.selenium.remote_driver;

    exports org.openqa.selenium.cli;
    exports org.openqa.selenium.concurrent;
    exports org.openqa.selenium.docker;
    exports org.openqa.selenium.docker.internal;
    exports org.openqa.selenium.docker.v1_40;
    exports org.openqa.selenium.events;
    exports org.openqa.selenium.events.local;
    exports org.openqa.selenium.events.zeromq;
    exports org.openqa.selenium.grid;
    exports org.openqa.selenium.grid.commands;
    exports org.openqa.selenium.grid.component;
    exports org.openqa.selenium.grid.config;
    exports org.openqa.selenium.grid.data;
    exports org.openqa.selenium.grid.distributor;
    exports org.openqa.selenium.grid.distributor.config;
    exports org.openqa.selenium.grid.distributor.httpd;
    exports org.openqa.selenium.grid.distributor.local;
    exports org.openqa.selenium.grid.distributor.remote;
    exports org.openqa.selenium.grid.distributor.selector;
    exports org.openqa.selenium.grid.docker;
    exports org.openqa.selenium.grid.graphql;
    exports org.openqa.selenium.grid.log;
    exports org.openqa.selenium.grid.node;
    exports org.openqa.selenium.grid.node.config;
    exports org.openqa.selenium.grid.node.httpd;
    exports org.openqa.selenium.grid.node.local;
    exports org.openqa.selenium.grid.node.remote;
    exports org.openqa.selenium.grid.router;
    exports org.openqa.selenium.grid.router.httpd;
    exports org.openqa.selenium.grid.security;
    exports org.openqa.selenium.grid.server;
    exports org.openqa.selenium.grid.sessionmap;
    exports org.openqa.selenium.grid.sessionmap.config;
    exports org.openqa.selenium.grid.sessionmap.httpd;
    exports org.openqa.selenium.grid.sessionmap.local;
    exports org.openqa.selenium.grid.sessionmap.remote;
    exports org.openqa.selenium.grid.sessionqueue;
    exports org.openqa.selenium.grid.sessionqueue.config;
    exports org.openqa.selenium.grid.sessionqueue.httpd;
    exports org.openqa.selenium.grid.sessionqueue.local;
    exports org.openqa.selenium.grid.sessionqueue.remote;
    exports org.openqa.selenium.grid.web;
    exports org.openqa.selenium.netty.server;
    exports org.openqa.selenium.status;

    provides CliCommand with CompletionCommand, EventBusCommand, Hub, InfoCommand, Standalone, DistributorServer, NodeServer, RouterServer, SessionMapServer, NewSessionQueuerServer;
    provides HasRoles with LoggingFlags, BaseServerFlags, EventBusFlags, SessionMapFlags, NewSessionQueueFlags, NewSessionQueuerFlags, DockerFlags, DistributorFlags, NodeFlags, RouterFlags;

}

