/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.config;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.sessionmap.SessionMap;

public class SessionMapOptions {
    private static final String SESSIONS_SECTION = "sessions";
    private static final Logger LOG = Logger.getLogger(SessionMapOptions.class.getName());
    private static final String DEFAULT_SESSION_MAP = "org.openqa.selenium.grid.sessionmap.remote.RemoteSessionMap";
    private final Config config;

    public SessionMapOptions(Config config) {
        this.config = config;
    }

    public URI getSessionMapUri() {
        Optional<URI> host = this.config.get(SESSIONS_SECTION, "host").map(str -> {
            try {
                return new URI((String)str);
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Session map server URI is not a valid URI: " + str, new Object[0]);
            }
        });
        if (host.isPresent()) {
            return host.get();
        }
        Optional<Integer> port = this.config.getInt(SESSIONS_SECTION, "port");
        Optional<String> hostname = this.config.get(SESSIONS_SECTION, "hostname");
        if (!port.isPresent() || !hostname.isPresent()) {
            throw new ConfigException("Unable to determine host and port for the session map server", new Object[0]);
        }
        try {
            return new URI("http", null, hostname.get(), port.get(), "", null, null);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Session map server uri configured through host (%s) and port (%d) is not a valid URI", hostname.get(), port.get());
        }
    }

    public SessionMap getSessionMap() {
        String clazz = this.config.get(SESSIONS_SECTION, "implementation").orElse(DEFAULT_SESSION_MAP);
        LOG.info("Creating session map: " + clazz);
        try {
            Class<?> busClazz = Class.forName(clazz);
            Method create = busClazz.getMethod("create", Config.class);
            if (!Modifier.isStatic(create.getModifiers())) {
                throw new IllegalArgumentException(String.format("Session map class %s's `create(Config)` method must be static", clazz));
            }
            if (!SessionMap.class.isAssignableFrom(create.getReturnType())) {
                throw new IllegalArgumentException(String.format("Session map class %s's `create(Config)` method must return a SessionMap", clazz));
            }
            return (SessionMap)create.invoke(null, this.config);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Session map class %s must have a static `create(Config)` method", clazz));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Unable to find event bus class: " + clazz, e);
        }
    }
}

