/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.log;

import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.MultiSpanProcessor;
import io.opentelemetry.sdk.trace.TracerSdkProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpansProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Optional;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.log.FlushingHandler;
import org.openqa.selenium.grid.log.JaegerTracing;
import org.openqa.selenium.grid.log.JsonFormatter;
import org.openqa.selenium.grid.log.TerseFormatter;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.remote.tracing.empty.NullTracer;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryTracer;

public class LoggingOptions {
    private static final Logger LOG = Logger.getLogger(LoggingOptions.class.getName());
    private static final String LOGGING_SECTION = "logging";
    private static Tracer tracer;
    private final Config config;

    public LoggingOptions(Config config) {
        this.config = (Config)Require.nonNull((String)"Config", (Object)config);
    }

    public boolean isUsingStructuredLogging() {
        return this.config.getBool(LOGGING_SECTION, "structured-logs").orElse(false);
    }

    public boolean isUsingPlainLogs() {
        return this.config.getBool(LOGGING_SECTION, "plain-logs").orElse(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracer getTracer() {
        boolean tracingEnabled = this.config.getBool(LOGGING_SECTION, "tracing").orElse(true);
        if (!tracingEnabled) {
            LOG.info("Using null tracer");
            return new NullTracer();
        }
        LOG.info("Using OpenTelemetry for tracing");
        if (tracer != null) {
            return tracer;
        }
        Class<LoggingOptions> clazz = LoggingOptions.class;
        synchronized (LoggingOptions.class) {
            if (tracer == null) {
                tracer = this.createTracer();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tracer;
        }
    }

    private Tracer createTracer() {
        LOG.info("Using OpenTelemetry for tracing");
        TracerSdkProvider tracerFactory = OpenTelemetrySdk.getTracerProvider();
        LinkedList<SimpleSpansProcessor> exporters = new LinkedList<SimpleSpansProcessor>();
        exporters.add(SimpleSpansProcessor.create((SpanExporter)new SpanExporter(){

            public SpanExporter.ResultCode export(Collection<SpanData> spans) {
                spans.forEach(span -> LOG.fine(String.valueOf(span)));
                return SpanExporter.ResultCode.SUCCESS;
            }

            public SpanExporter.ResultCode flush() {
                return SpanExporter.ResultCode.SUCCESS;
            }

            public void shutdown() {
            }
        }));
        Optional<SpanExporter> maybeJaeger = JaegerTracing.findJaegerExporter();
        maybeJaeger.ifPresent(exporter -> exporters.add(SimpleSpansProcessor.create((SpanExporter)exporter)));
        tracerFactory.addSpanProcessor(MultiSpanProcessor.create(exporters));
        return new OpenTelemetryTracer((io.opentelemetry.trace.Tracer)tracerFactory.get("default"), OpenTelemetry.getPropagators().getHttpTextFormat());
    }

    public void configureLogging() {
        FlushingHandler handler;
        Logger logger;
        if (!this.config.getBool(LOGGING_SECTION, "enable").orElse(true).booleanValue()) {
            return;
        }
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> names = logManager.getLoggerNames();
        while (names.hasMoreElements()) {
            logger = logManager.getLogger(names.nextElement());
            Arrays.stream(logger.getHandlers()).forEach(logger::removeHandler);
        }
        logger = logManager.getLogger("");
        if (this.isUsingPlainLogs()) {
            handler = new FlushingHandler(System.out);
            handler.setFormatter(new TerseFormatter());
            logger.addHandler(handler);
        }
        if (this.isUsingStructuredLogging()) {
            handler = new FlushingHandler(System.out);
            handler.setFormatter(new JsonFormatter());
            logger.addHandler(handler);
        }
    }
}

