/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor;

import java.io.UncheckedIOException;
import java.util.UUID;
import java.util.function.Predicate;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.distributor.AddNode;
import org.openqa.selenium.grid.distributor.CreateSession;
import org.openqa.selenium.grid.distributor.GetDistributorStatus;
import org.openqa.selenium.grid.distributor.RemoveNode;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.SpanDecorator;
import org.openqa.selenium.remote.tracing.Tracer;

public abstract class Distributor
implements Predicate<HttpRequest>,
Routable,
HttpHandler {
    private final Route routes;
    protected final Tracer tracer;

    protected Distributor(Tracer tracer, HttpClient.Factory httpClientFactory) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        Require.nonNull((String)"HTTP client factory", (Object)httpClientFactory);
        Json json = new Json();
        this.routes = Route.combine((Routable)Route.post((String)"/session").to(() -> req -> {
            CreateSessionResponse sessionResponse = this.newSession(req);
            return (HttpResponse)new HttpResponse().setContent(Contents.bytes((byte[])sessionResponse.getDownstreamEncodedResponse()));
        }), (Routable[])new Routable[]{Route.post((String)"/se/grid/distributor/session").to(() -> new CreateSession(this)), Route.post((String)"/se/grid/distributor/node").to(() -> new AddNode(tracer, this, json, httpClientFactory)), Route.delete((String)"/se/grid/distributor/node/{nodeId}").to(params -> new RemoveNode(this, UUID.fromString((String)params.get("nodeId")))), Route.get((String)"/se/grid/distributor/status").to(() -> new GetDistributorStatus(this)).with((Filter)new SpanDecorator(tracer, req -> "distributor.status"))});
    }

    public abstract CreateSessionResponse newSession(HttpRequest var1) throws SessionNotCreatedException;

    public abstract Distributor add(Node var1);

    public abstract void remove(UUID var1);

    public abstract DistributorStatus getStatus();

    @Override
    public boolean test(HttpRequest httpRequest) {
        return this.matches(httpRequest);
    }

    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        return this.routes.execute(req);
    }
}

