/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.google.common.collect.ImmutableSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.TemplateGridCommand;
import org.openqa.selenium.grid.commands.DefaultHubConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.distributor.local.LocalDistributor;
import org.openqa.selenium.grid.graphql.GraphqlHandler;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.router.ProxyCdpIntoGrid;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.sessionmap.local.LocalSessionMap;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.grid.web.RoutableHttpClientFactory;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;

public class Hub
extends TemplateGridCommand {
    private static final Logger LOG = Logger.getLogger(Hub.class.getName());

    @Override
    public String getName() {
        return "hub";
    }

    @Override
    public String getDescription() {
        return "A grid hub, composed of sessions, distributor, and router.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.HTTPD_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "selenium";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultHubConfig();
    }

    @Override
    protected void execute(Config config) {
        URL externalUrl;
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        EventBusOptions events = new EventBusOptions(config);
        EventBus bus = events.getEventBus();
        CombinedHandler handler = new CombinedHandler();
        LocalSessionMap sessions = new LocalSessionMap(tracer, bus);
        handler.addHandler(sessions);
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        try {
            externalUrl = serverOptions.getExternalUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        NetworkOptions networkOptions = new NetworkOptions(config);
        RoutableHttpClientFactory clientFactory = new RoutableHttpClientFactory(externalUrl, handler, networkOptions.getHttpClientFactory(tracer));
        LocalDistributor distributor = new LocalDistributor(tracer, bus, clientFactory, sessions, null);
        handler.addHandler(distributor);
        Router router = new Router(tracer, clientFactory, sessions, distributor);
        GraphqlHandler graphqlHandler = new GraphqlHandler(distributor, serverOptions.getExternalUri().toString());
        Route httpHandler = Route.combine((Routable)router, (Routable[])new Routable[]{Route.prefix((String)"/wd/hub").to(Route.combine((Routable)router, (Routable[])new Routable[0])), Route.post((String)"/graphql").to(() -> graphqlHandler)});
        NettyServer server = new NettyServer(serverOptions, (HttpHandler)httpHandler, new ProxyCdpIntoGrid(clientFactory, sessions));
        server.start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium hub %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }
}

