/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import java.time.Duration;
import java.util.logging.Logger;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.DockerProtocol;
import org.openqa.selenium.internal.Require;

public class Container {
    private static final Logger LOG = Logger.getLogger(Container.class.getName());
    private final DockerProtocol protocol;
    private final ContainerId id;

    public Container(DockerProtocol protocol, ContainerId id) {
        this.protocol = (DockerProtocol)Require.nonNull((String)"Protocol", (Object)protocol);
        this.id = (ContainerId)Require.nonNull((String)"Container id", (Object)id);
        LOG.info("Created container " + id);
    }

    public ContainerId getId() {
        return this.id;
    }

    public void start() {
        LOG.info("Starting " + this.getId());
        this.protocol.startContainer(this.id);
    }

    public void stop(Duration timeout) {
        Require.nonNull((String)"Timeout to wait for", (Object)timeout);
        if (this.protocol.exists(this.id)) {
            LOG.info("Stopping " + this.getId());
            this.protocol.stopContainer(this.id, timeout);
        }
    }

    public void delete() {
        if (this.protocol.exists(this.id)) {
            LOG.info("Removing " + this.getId());
            this.protocol.deleteContainer(this.id);
        }
    }
}

