/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.net.ssl.SSLException;
import org.openqa.selenium.grid.server.AddWebDriverSpecHeaders;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.grid.server.WrapExceptions;
import org.openqa.selenium.netty.server.SeleniumHttpInitializer;
import org.openqa.selenium.remote.http.HttpHandler;

public class NettyServer
implements Server<NettyServer> {
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final int port;
    private final URL externalUrl;
    private final HttpHandler handler;
    private final SslContext sslCtx;
    private Channel channel;

    public NettyServer(BaseServerOptions options, HttpHandler handler) {
        Objects.requireNonNull(options, "Server options must be set.");
        Objects.requireNonNull(handler, "Handler to use must be set.");
        Boolean secure = options.isSecure();
        if (secure.booleanValue()) {
            try {
                this.sslCtx = SslContextBuilder.forServer((File)options.getCertificate(), (File)options.getPrivateKey()).build();
            }
            catch (SSLException e) {
                throw new UncheckedIOException(new IOException("Certificate problem.", e));
            }
        } else {
            this.sslCtx = null;
        }
        this.handler = handler.with(new WrapExceptions().andThen(new AddWebDriverSpecHeaders()));
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        this.port = options.getPort();
        try {
            this.externalUrl = options.getExternalUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException("Server URI is not a valid URL: " + options.getExternalUri(), e);
        }
    }

    @Override
    public boolean isStarted() {
        return this.channel != null;
    }

    @Override
    public URL getUrl() {
        return this.externalUrl;
    }

    @Override
    public void stop() {
        try {
            this.channel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(new IOException("Shutdown interrupted", e));
        }
        finally {
            this.channel = null;
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
        }
    }

    @Override
    public NettyServer start() {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new SeleniumHttpInitializer(this.handler, this.sslCtx));
        try {
            this.channel = b.bind(this.port).sync().channel();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(new IOException("Start up interrupted", e));
        }
        return this;
    }
}

