/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.config;

import io.opentracing.Tracer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.remote.RemoteSessionMap;
import org.openqa.selenium.remote.http.HttpClient;

public class SessionMapOptions {
    private final Config config;

    public SessionMapOptions(Config config) {
        this.config = config;
    }

    public SessionMap getSessionMap(Tracer tracer, HttpClient.Factory clientFactory) {
        HttpClient client = clientFactory.createClient(this.getSessionMapUrl());
        return new RemoteSessionMap(tracer, client);
    }

    private URL getSessionMapUrl() {
        Optional<URL> host = this.config.get("sessions", "host").map(str -> {
            try {
                return new URL((String)str);
            }
            catch (MalformedURLException e) {
                throw new ConfigException("Session map server URI is not a valid URI: " + str, new Object[0]);
            }
        });
        if (host.isPresent()) {
            return host.get();
        }
        Optional<Integer> port = this.config.getInt("sessions", "port");
        Optional<String> hostname = this.config.get("sessions", "hostname");
        if (!port.isPresent() || !hostname.isPresent()) {
            throw new ConfigException("Unable to determine host and port for the session map server", new Object[0]);
        }
        try {
            return new URL("http", hostname.get(), port.get(), "");
        }
        catch (MalformedURLException e) {
            throw new ConfigException("Session map server uri configured through host (%s) and port (%d) is not a valid URI", hostname.get(), port.get());
        }
    }
}

