/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.Objects;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;

class RemoveFromSession
implements HttpHandler {
    private final Tracer tracer;
    private final SessionMap sessions;
    private final SessionId id;

    public RemoveFromSession(Tracer tracer, SessionMap sessions, SessionId id) {
        this.tracer = Objects.requireNonNull(tracer);
        this.sessions = Objects.requireNonNull(sessions);
        this.id = Objects.requireNonNull(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(HttpRequest req) {
        SpanContext parent = HttpTracing.extract((Tracer)this.tracer, (HttpRequest)req);
        Span current = this.tracer.scopeManager().activeSpan();
        Span span = this.tracer.buildSpan("sessions.remove_session").asChildOf(parent).start();
        this.tracer.scopeManager().activate(span);
        try {
            Tags.HTTP_METHOD.set(span, req.getMethod().toString());
            Tags.HTTP_URL.set(span, req.getUri());
            span.setTag("session.id", String.valueOf(this.id));
            this.sessions.remove(this.id);
            HttpResponse httpResponse = new HttpResponse();
            return httpResponse;
        }
        finally {
            span.finish();
            this.tracer.scopeManager().activate(current);
        }
    }
}

