/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.internal.Console;
import java.io.PrintStream;
import org.openqa.selenium.BuildInfo;

public class HelpFlags {
    @Parameter(names={"-h", "-help", "--help", "/?"}, help=true, hidden=true)
    private boolean help;
    @Parameter(names={"--version"}, description="Displays the version and exits.")
    private boolean version;

    public boolean displayHelp(JCommander commander, PrintStream outputTo) {
        if (this.version) {
            BuildInfo info = new BuildInfo();
            outputTo.printf("%s version: %s, revision: %s\n", commander.getProgramName(), info.getReleaseLabel(), info.getBuildRevision());
            return true;
        }
        if (this.help) {
            final StringBuilder text = new StringBuilder();
            commander.setConsole(new Console(){

                public void print(String msg) {
                    text.append(msg);
                }

                public void println(String msg) {
                    text.append(msg).append("\n");
                }

                public char[] readPassword(boolean echoInput) {
                    throw new UnsupportedOperationException("readPassword");
                }
            });
            commander.usage();
            outputTo.println(text.toString());
            return true;
        }
        return false;
    }
}

