/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import io.opentracing.Tracer;
import java.net.URL;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.node.BaseActiveSession;
import org.openqa.selenium.grid.web.ProtocolConverter;
import org.openqa.selenium.grid.web.ReverseProxyHandler;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public abstract class ProtocolConvertingSession
extends BaseActiveSession {
    private final HttpHandler handler;
    private final String killUrl;

    protected ProtocolConvertingSession(Tracer tracer, HttpClient client, SessionId id, URL url, Dialect downstream, Dialect upstream, Capabilities capabilities) {
        super(id, url, downstream, upstream, capabilities);
        Objects.requireNonNull(client);
        this.handler = downstream.equals((Object)upstream) ? new ReverseProxyHandler(tracer, client) : new ProtocolConverter(tracer, client, downstream, upstream);
        this.killUrl = "/session/" + id;
    }

    public HttpResponse execute(HttpRequest req) {
        HttpResponse res = this.handler.execute(req);
        if (req.getMethod() == HttpMethod.DELETE && this.killUrl.equals(req.getUri())) {
            this.stop();
        }
        return res;
    }
}

