/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import io.opentracing.Tracer;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.component.HealthCheck;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.node.ForwardWebDriverCommand;
import org.openqa.selenium.grid.node.GetNodeSession;
import org.openqa.selenium.grid.node.IsSessionOwner;
import org.openqa.selenium.grid.node.NewNodeSession;
import org.openqa.selenium.grid.node.StatusHandler;
import org.openqa.selenium.grid.node.StopNodeSession;
import org.openqa.selenium.grid.node.UploadFile;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.SpanDecorator;

public abstract class Node
implements Routable,
HttpHandler {
    protected final Tracer tracer;
    private final UUID id;
    private final URI uri;
    private final Route routes;

    protected Node(Tracer tracer, UUID id, URI uri) {
        this.tracer = Objects.requireNonNull(tracer);
        this.id = Objects.requireNonNull(id);
        this.uri = Objects.requireNonNull(uri);
        Json json = new Json();
        this.routes = Route.combine((Routable)Route.matching(req -> HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).map(this::isSessionOwner).orElse(false)).to(() -> new ForwardWebDriverCommand(this)).with((Filter)new SpanDecorator(tracer, req -> "node.forward_command")), (Routable[])new Routable[]{Route.post((String)"/session/{sessionId}/file").to(() -> new UploadFile(this, json)).with((Filter)new SpanDecorator(tracer, req -> "node.upload_file")), Route.get((String)"/se/grid/node/owner/{sessionId}").to(params -> new IsSessionOwner(this, json, new SessionId((String)params.get("sessionId")))).with((Filter)new SpanDecorator(tracer, req -> "node.is_session_owner")), Route.delete((String)"/se/grid/node/session/{sessionId}").to(params -> new StopNodeSession(this, new SessionId((String)params.get("sessionId")))).with((Filter)new SpanDecorator(tracer, req -> "node.stop_session")), Route.get((String)"/se/grid/node/session/{sessionId}").to(params -> new GetNodeSession(this, json, new SessionId((String)params.get("sessionId")))).with((Filter)new SpanDecorator(tracer, req -> "node.get_session")), Route.post((String)"/se/grid/node/session").to(() -> new NewNodeSession(this, json)).with((Filter)new SpanDecorator(tracer, req -> "node.new_session")), Route.get((String)"/se/grid/node/status").to(() -> req -> (HttpResponse)new HttpResponse().setContent(Contents.utf8String((CharSequence)json.toJson((Object)this.getStatus())))).with((Filter)new SpanDecorator(tracer, req -> "node.node_status")), Route.get((String)"/status").to(() -> new StatusHandler(this, json)).with((Filter)new SpanDecorator(tracer, req -> "node.status"))});
    }

    public UUID getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public abstract Optional<CreateSessionResponse> newSession(CreateSessionRequest var1);

    public abstract HttpResponse executeWebDriverCommand(HttpRequest var1);

    public abstract Session getSession(SessionId var1) throws NoSuchSessionException;

    public abstract void stop(SessionId var1) throws NoSuchSessionException;

    protected abstract boolean isSessionOwner(SessionId var1);

    public abstract boolean isSupporting(Capabilities var1);

    public abstract NodeStatus getStatus();

    public abstract HealthCheck getHealthCheck();

    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    public HttpResponse execute(HttpRequest req) {
        return this.routes.execute(req);
    }
}

