/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.concurrent.Regularly;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.NodeStatusEvent;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.distributor.local.Host;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.remote.RemoteNode;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;

public class LocalDistributor
extends Distributor {
    private static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger("Selenium Distributor (Local)");
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Set<Host> hosts = new HashSet<Host>();
    private final Tracer tracer;
    private final EventBus bus;
    private final HttpClient.Factory clientFactory;
    private final SessionMap sessions;
    private final Regularly hostChecker = new Regularly("distributor host checker");
    private final Map<UUID, Collection<Runnable>> allChecks = new ConcurrentHashMap<UUID, Collection<Runnable>>();

    public LocalDistributor(Tracer tracer, EventBus bus, HttpClient.Factory clientFactory, SessionMap sessions) {
        super(tracer, clientFactory);
        this.tracer = Objects.requireNonNull(tracer);
        this.bus = Objects.requireNonNull(bus);
        this.clientFactory = Objects.requireNonNull(clientFactory);
        this.sessions = Objects.requireNonNull(sessions);
        bus.addListener(NodeStatusEvent.NODE_STATUS, event -> this.refresh((NodeStatus)event.getData((Type)((Object)NodeStatus.class))));
    }

    /*
     * Exception decompiling
     */
    @Override
    public CreateSessionResponse newSession(HttpRequest request) throws SessionNotCreatedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    Stream<Host> getPrioritizedHostStream(Stream<Host> hostStream, Capabilities capabilities) {
        Set<Host> filteredHostSet = hostStream.collect(Collectors.toSet());
        Map<String, Set<Host>> hostBuckets = this.sortHostsToBucketsByBrowser(filteredHostSet);
        if (this.allBucketsSameSize(hostBuckets)) {
            return hostBuckets.values().stream().distinct().flatMap(Collection::stream);
        }
        List sorted = hostBuckets.entrySet().stream().sorted(Comparator.comparingInt(v -> ((Set)v.getValue()).size())).collect(Collectors.toList());
        for (Map.Entry entry : sorted) {
            Set<Host> filteredHosts;
            Map<String, Set<Host>> newHostBuckets;
            if (((String)entry.getKey()).equals(capabilities.getBrowserName()) || !this.allBucketsSameSize(newHostBuckets = this.sortHostsToBucketsByBrowser(filteredHosts = filteredHostSet.stream().filter(host -> !((Set)entry.getValue()).contains(host)).collect(Collectors.toSet())))) continue;
            LOG.fine("Hosts have been balanced according to browser priority");
            return newHostBuckets.values().stream().distinct().flatMap(Collection::stream);
        }
        return hostBuckets.values().stream().distinct().flatMap(Collection::stream);
    }

    @VisibleForTesting
    Map<String, Set<Host>> sortHostsToBucketsByBrowser(Set<Host> hostSet) {
        HashMap<String, Set<Host>> hostBuckets = new HashMap<String, Set<Host>>();
        hostSet.forEach(host -> host.asSummary().getStereotypes().forEach((k, v) -> {
            if (!hostBuckets.containsKey(k.getBrowserName())) {
                HashSet<Host> newSet = new HashSet<Host>();
                newSet.add((Host)host);
                hostBuckets.put(k.getBrowserName(), newSet);
            }
            ((Set)hostBuckets.get(k.getBrowserName())).add(host);
        }));
        return hostBuckets;
    }

    @VisibleForTesting
    boolean allBucketsSameSize(Map<String, Set<Host>> hostBuckets) {
        HashSet intSet = new HashSet();
        hostBuckets.values().forEach(bucket -> intSet.add(bucket.size()));
        return intSet.size() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(NodeStatus status) {
        Objects.requireNonNull(status);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            Optional<Host> existing = this.hosts.stream().filter(host -> host.getId().equals(status.getNodeId())).findFirst();
            if (existing.isPresent()) {
                existing.get().update(status);
            } else {
                RemoteNode node = new RemoteNode(this.tracer, this.clientFactory, status.getNodeId(), status.getUri(), status.getStereotypes().keySet());
                this.add(node, status);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public LocalDistributor add(Node node) {
        return this.add(node, node.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalDistributor add(Node node, NodeStatus status) {
        StringBuilder sb = new StringBuilder();
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try (JsonOutput out = JSON.newOutput((Appendable)sb);){
            out.setPrettyPrint(false).write((Object)node);
            Host host = new Host(this.bus, node);
            host.update(status);
            this.hosts.add(host);
            LOG.info(String.format("Added node %s.", node.getId()));
            host.runHealthCheck();
            Runnable runnable = host::runHealthCheck;
            Collection nodeRunnables = this.allChecks.getOrDefault(node.getId(), new ArrayList());
            nodeRunnables.add(runnable);
            this.allChecks.put(node.getId(), nodeRunnables);
            this.hostChecker.submit(runnable, Duration.ofMinutes(5L), Duration.ofSeconds(30L));
        }
        finally {
            writeLock.unlock();
        }
        return this;
    }

    @Override
    public void remove(UUID nodeId) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.hosts.removeIf(host -> nodeId.equals(host.getId()));
            ((Collection)this.allChecks.getOrDefault(nodeId, new ArrayList())).forEach(this.hostChecker::remove);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DistributorStatus getStatus() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            ImmutableSet summaries = (ImmutableSet)this.hosts.stream().map(Host::asSummary).collect(ImmutableSet.toImmutableSet());
            DistributorStatus distributorStatus = new DistributorStatus((Collection<DistributorStatus.NodeSummary>)summaries);
            return distributorStatus;
        }
        finally {
            readLock.unlock();
        }
    }

    @Beta
    @VisibleForTesting
    public void refresh() {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.hosts.forEach(Host::runHealthCheck);
        }
        finally {
            writeLock.unlock();
        }
    }

    private static /* synthetic */ SessionNotCreatedException lambda$newSession$4(Span span, NewSessionPayload payload) {
        span.setTag((Tag)Tags.ERROR, (Object)true);
        return new SessionNotCreatedException("Unable to find provider for session: " + payload.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    private static /* synthetic */ Supplier lambda$newSession$3(CreateSessionRequest firstRequest, Host host) {
        return host.reserve(firstRequest);
    }

    private static /* synthetic */ boolean lambda$newSession$2(CreateSessionRequest firstRequest, Host host) {
        return host.hasCapacity(firstRequest.getCapabilities());
    }

    private static /* synthetic */ boolean lambda$newSession$1(Host host) {
        return host.getHostStatus() == Host.Status.UP;
    }
}

