/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor;

import io.opentracing.Tracer;
import java.util.Objects;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.node.remote.RemoteNode;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class AddNode
implements HttpHandler {
    private final Tracer tracer;
    private final Distributor distributor;
    private final Json json;
    private final HttpClient.Factory httpFactory;

    public AddNode(Tracer tracer, Distributor distributor, Json json, HttpClient.Factory httpFactory) {
        this.tracer = Objects.requireNonNull(tracer);
        this.distributor = Objects.requireNonNull(distributor);
        this.json = Objects.requireNonNull(json);
        this.httpFactory = Objects.requireNonNull(httpFactory);
    }

    public HttpResponse execute(HttpRequest req) {
        NodeStatus status = (NodeStatus)this.json.toType(Contents.string((HttpMessage)req), NodeStatus.class);
        RemoteNode node = new RemoteNode(this.tracer, this.httpFactory, status.getNodeId(), status.getUri(), status.getStereotypes().keySet());
        this.distributor.add(node);
        return new HttpResponse();
    }
}

