/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.grid.config.Config;

public class EnvConfig
implements Config {
    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Objects.requireNonNull(section, "Section name not set");
        Objects.requireNonNull(option, "Option name not set");
        String key = String.format("%s_%s", section, option).toUpperCase(Locale.US).replace("-", "_").replace(".", "_");
        String value = System.getenv().get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value.startsWith("$")) {
            value = System.getenv(value.substring(1));
        }
        return Optional.ofNullable(value).map(ImmutableList::of);
    }
}

