/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.firefox.HasExtensions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.HttpMethod;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasExtensions
implements AugmenterProvider<HasExtensions>,
AdditionalHttpCommands {
    public static final String INSTALL_EXTENSION = "installExtension";
    public static final String UNINSTALL_EXTENSION = "uninstallExtension";
    private static final Map<String, CommandInfo> COMMANDS = ImmutableMap.of((Object)"installExtension", (Object)new CommandInfo("/session/:sessionId/moz/addon/install", HttpMethod.POST), (Object)"uninstallExtension", (Object)new CommandInfo("/session/:sessionId/moz/addon/uninstall", HttpMethod.POST));

    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    public Predicate<Capabilities> isApplicable() {
        return arg_0 -> ((Browser)Browser.FIREFOX).is(arg_0);
    }

    public Class<HasExtensions> getDescribedInterface() {
        return HasExtensions.class;
    }

    public HasExtensions getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasExtensions(){

            @Override
            public String installExtension(Path path) {
                return this.installExtension(path, false);
            }

            @Override
            public String installExtension(Path path, Boolean temporary) {
                String encoded;
                Require.nonNull((String)"Extension Path", (Object)path);
                Require.nonNull((String)"Temporary", (Object)temporary);
                try {
                    encoded = Base64.getEncoder().encodeToString(Files.readAllBytes(path));
                }
                catch (IOException e) {
                    throw new InvalidArgumentException(path + " is an invalid path", (Throwable)e);
                }
                return (String)executeMethod.execute(AddHasExtensions.INSTALL_EXTENSION, (Map)ImmutableMap.of((Object)"addon", (Object)encoded, (Object)"temporary", (Object)temporary));
            }

            @Override
            public void uninstallExtension(String extensionId) {
                Require.nonNull((String)"Extension ID", (Object)extensionId);
                executeMethod.execute(AddHasExtensions.UNINSTALL_EXTENSION, (Map)ImmutableMap.of((Object)"id", (Object)extensionId));
            }
        };
    }
}

