/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.Preferences;
import org.openqa.selenium.firefox.UnableToCreateProfileException;
import org.openqa.selenium.firefox.internal.ClasspathExtension;
import org.openqa.selenium.firefox.internal.Extension;
import org.openqa.selenium.firefox.internal.FileExtension;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;

public class FirefoxProfile {
    public static final String PORT_PREFERENCE = "webdriver_firefox_port";
    public static final String ALLOWED_HOSTS_PREFERENCE = "webdriver_firefox_allowed_hosts";
    private static final String defaultPrefs = "/org/openqa/selenium/firefox/webdriver_prefs.json";
    private Preferences additionalPrefs;
    private Map<String, Extension> extensions = Maps.newHashMap();
    private boolean loadNoFocusLib;
    private boolean acceptUntrustedCerts;
    private boolean untrustedCertIssuer;
    private File model;
    private static final String ACCEPT_UNTRUSTED_CERTS_PREF = "webdriver_accept_untrusted_certs";
    private static final String ASSUME_UNTRUSTED_ISSUER_PREF = "webdriver_assume_untrusted_issuer";

    public FirefoxProfile() {
        this(null);
    }

    public FirefoxProfile(File profileDir) {
        this(null, profileDir);
    }

    @Beta
    @VisibleForTesting
    protected FirefoxProfile(Reader defaultsReader, File profileDir) {
        if (defaultsReader == null) {
            defaultsReader = this.onlyOverrideThisIfYouKnowWhatYouAreDoing();
        }
        this.additionalPrefs = new Preferences(defaultsReader);
        this.model = profileDir;
        this.verifyModel(this.model);
        File prefsInModel = new File(this.model, "user.js");
        if (prefsInModel.exists()) {
            StringReader reader = new StringReader("{\"frozen\": {}, \"mutable\": {}}");
            Preferences existingPrefs = new Preferences((Reader)reader, prefsInModel);
            this.acceptUntrustedCerts = this.getBooleanPreference(existingPrefs, ACCEPT_UNTRUSTED_CERTS_PREF, true);
            this.untrustedCertIssuer = this.getBooleanPreference(existingPrefs, ASSUME_UNTRUSTED_ISSUER_PREF, true);
            existingPrefs.addTo(this.additionalPrefs);
        } else {
            this.acceptUntrustedCerts = true;
            this.untrustedCertIssuer = true;
        }
        this.loadNoFocusLib = false;
        try {
            defaultsReader.close();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    @Beta
    protected Reader onlyOverrideThisIfYouKnowWhatYouAreDoing() {
        URL resource = Resources.getResource(FirefoxProfile.class, (String)defaultPrefs);
        try {
            return new InputStreamReader(resource.openStream());
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private boolean getBooleanPreference(Preferences prefs, String key, boolean defaultValue) {
        Object value = prefs.getPreference(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new WebDriverException("Expected boolean value is not a boolean. It is: " + value);
    }

    public String getStringPreference(String key, String defaultValue) {
        Object preference = this.additionalPrefs.getPreference(key);
        if (preference != null && preference instanceof String) {
            return (String)preference;
        }
        return defaultValue;
    }

    public int getIntegerPreference(String key, int defaultValue) {
        Object preference = this.additionalPrefs.getPreference(key);
        if (preference != null && preference instanceof Integer) {
            return (Integer)preference;
        }
        return defaultValue;
    }

    public boolean getBooleanPreference(String key, boolean defaultValue) {
        Object preference = this.additionalPrefs.getPreference(key);
        if (preference != null && preference instanceof Boolean) {
            return (Boolean)preference;
        }
        return defaultValue;
    }

    private void verifyModel(File model) {
        if (model == null) {
            return;
        }
        if (!model.exists()) {
            throw new UnableToCreateProfileException("Given model profile directory does not exist: " + model.getPath());
        }
        if (!model.isDirectory()) {
            throw new UnableToCreateProfileException("Given model profile directory is not a directory: " + model.getAbsolutePath());
        }
    }

    public boolean containsWebDriverExtension() {
        return this.extensions.containsKey("webdriver");
    }

    public void addExtension(Class<?> loadResourcesUsing, String loadFrom) {
        File file = new File(loadFrom);
        if (file.exists()) {
            this.addExtension(file);
            return;
        }
        this.addExtension(loadFrom, new ClasspathExtension(loadResourcesUsing, loadFrom));
    }

    public void addExtension(File extensionToInstall) {
        this.addExtension(extensionToInstall.getName(), new FileExtension(extensionToInstall));
    }

    public void addExtension(String key, Extension extension) {
        String name = this.deriveExtensionName(key);
        this.extensions.put(name, extension);
    }

    private String deriveExtensionName(String originalName) {
        String[] pieces = originalName.replace('\\', '/').split("/");
        String name = pieces[pieces.length - 1];
        name = name.replaceAll("\\..*?$", "");
        return name;
    }

    public void setPreference(String key, String value) {
        this.additionalPrefs.setPreference(key, value);
    }

    public void setPreference(String key, boolean value) {
        this.additionalPrefs.setPreference(key, value);
    }

    public void setPreference(String key, int value) {
        this.additionalPrefs.setPreference(key, value);
    }

    protected Preferences getAdditionalPreferences() {
        return this.additionalPrefs;
    }

    public void updateUserPrefs(File userPrefs) {
        Preferences prefs = new Preferences(this.onlyOverrideThisIfYouKnowWhatYouAreDoing());
        prefs.setPreference("browser.startup.homepage", "about:blank");
        prefs.setPreference("browser.startup.page", 0);
        if (userPrefs.exists()) {
            prefs = new Preferences(this.onlyOverrideThisIfYouKnowWhatYouAreDoing(), userPrefs);
            if (!userPrefs.delete()) {
                throw new WebDriverException("Cannot delete existing user preferences");
            }
        }
        this.additionalPrefs.addTo(prefs);
        prefs.setPreference(ACCEPT_UNTRUSTED_CERTS_PREF, this.acceptUntrustedCerts);
        prefs.setPreference(ASSUME_UNTRUSTED_ISSUER_PREF, this.untrustedCertIssuer);
        Object homePage = prefs.getPreference("browser.startup.homepage");
        if (homePage != null && homePage instanceof String) {
            prefs.setPreference("startup.homepage_welcome_url", "");
        }
        if (!"about:blank".equals(prefs.getPreference("browser.startup.homepage"))) {
            prefs.setPreference("browser.startup.page", 1);
        }
        try (FileWriter writer = new FileWriter(userPrefs);){
            prefs.writeTo(writer);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    protected void deleteLockFiles(File profileDir) {
        File macAndLinuxLockFile = new File(profileDir, ".parentlock");
        File windowsLockFile = new File(profileDir, "parent.lock");
        macAndLinuxLockFile.delete();
        windowsLockFile.delete();
    }

    public void deleteExtensionsCacheIfItExists(File profileDir) {
        File cacheFile = new File(profileDir, "extensions.cache");
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
    }

    @Deprecated
    public boolean areNativeEventsEnabled() {
        return false;
    }

    @Deprecated
    public void setEnableNativeEvents(boolean enableNativeEvents) {
    }

    public boolean shouldLoadNoFocusLib() {
        return this.loadNoFocusLib;
    }

    public void setAlwaysLoadNoFocusLib(boolean loadNoFocusLib) {
        this.loadNoFocusLib = loadNoFocusLib;
    }

    public void setAcceptUntrustedCertificates(boolean acceptUntrustedSsl) {
        this.acceptUntrustedCerts = acceptUntrustedSsl;
    }

    public void setAssumeUntrustedCertificateIssuer(boolean untrustedIssuer) {
        this.untrustedCertIssuer = untrustedIssuer;
    }

    public void clean(File profileDir) {
        TemporaryFilesystem.getDefaultTmpFS().deleteTempDir(profileDir);
    }

    public String toJson() throws IOException {
        return Zip.zip((File)this.layoutOnDisk());
    }

    public static FirefoxProfile fromJson(String json) throws IOException {
        return new FirefoxProfile(Zip.unzipToTempDir((String)json, (String)"webdriver", (String)"duplicated"));
    }

    protected void cleanTemporaryModel() {
        this.clean(this.model);
    }

    public File layoutOnDisk() {
        try {
            File profileDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("anonymous", "webdriver-profile");
            File userPrefs = new File(profileDir, "user.js");
            this.copyModel(this.model, profileDir);
            this.installExtensions(profileDir);
            this.deleteLockFiles(profileDir);
            this.deleteExtensionsCacheIfItExists(profileDir);
            this.updateUserPrefs(userPrefs);
            return profileDir;
        }
        catch (IOException e) {
            throw new UnableToCreateProfileException(e);
        }
    }

    protected void copyModel(File sourceDir, File profileDir) throws IOException {
        if (sourceDir == null || !sourceDir.exists()) {
            return;
        }
        FileHandler.copy((File)sourceDir, (File)profileDir);
    }

    protected void installExtensions(File parentDir) throws IOException {
        File extensionsDir = new File(parentDir, "extensions");
        for (Extension extension : this.extensions.values()) {
            extension.writeTo(extensionsDir);
        }
    }
}

