/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxOptions {
    public static final String FIREFOX_OPTIONS = "firefoxOptions";
    private String binary;
    private FirefoxProfile profile;
    private List<String> args = new ArrayList<String>();
    private Map<String, Boolean> booleanPrefs = new HashMap<String, Boolean>();
    private Map<String, Integer> intPrefs = new HashMap<String, Integer>();
    private Map<String, String> stringPrefs = new HashMap<String, String>();

    public FirefoxOptions setBinary(Path path) {
        return this.setBinary(((Path)Preconditions.checkNotNull((Object)path)).toString());
    }

    public FirefoxOptions setBinary(String binary) {
        this.binary = (String)Preconditions.checkNotNull((Object)binary);
        return this;
    }

    public FirefoxOptions setProfile(FirefoxProfile profile) {
        this.profile = (FirefoxProfile)Preconditions.checkNotNull((Object)profile);
        return this;
    }

    FirefoxOptions setProfileSafely(FirefoxProfile profile) {
        Preconditions.checkState((this.profile == null || this.profile.equals(profile) ? 1 : 0) != 0, (Object)"Profile passed to options is different from existing profile that has been set.");
        return this.setProfile(profile);
    }

    public FirefoxOptions addArguments(String ... arguments) {
        this.addArguments((List<String>)ImmutableList.copyOf((Object[])arguments));
        return this;
    }

    public FirefoxOptions addArguments(List<String> arguments) {
        this.args.addAll(arguments);
        return this;
    }

    public FirefoxOptions addPreference(String key, boolean value) {
        this.booleanPrefs.put((String)Preconditions.checkNotNull((Object)key), value);
        return this;
    }

    public FirefoxOptions addPreference(String key, int value) {
        this.intPrefs.put((String)Preconditions.checkNotNull((Object)key), value);
        return this;
    }

    public FirefoxOptions addPreference(String key, String value) {
        this.stringPrefs.put((String)Preconditions.checkNotNull((Object)key), (String)Preconditions.checkNotNull((Object)value));
        return this;
    }

    public DesiredCapabilities addTo(DesiredCapabilities capabilities) {
        Object priorBinary = capabilities.getCapability("firefox_binary");
        if (this.binary != null && priorBinary != null && !this.binary.equals(priorBinary)) {
            throw new IllegalStateException("Binary already set in capabilities, but is different from the one in these options");
        }
        Object priorProfile = capabilities.getCapability("firefox_profile");
        if (priorProfile != null) {
            if (!(this.booleanPrefs.isEmpty() && this.intPrefs.isEmpty() && this.stringPrefs.isEmpty())) {
                throw new IllegalStateException("Unable to determine if preferences set on this option are the same as the profile in the capabilities");
            }
            if (!priorProfile.equals(this.profile)) {
                throw new IllegalStateException("Profile has been set on both the capabilities and these options, but they're different. Unable to determine which one you want to use.");
            }
        }
        capabilities.setCapability(FIREFOX_OPTIONS, (Object)this);
        if (this.binary != null) {
            FirefoxBinary actualBinary = new FirefoxBinary(new File(this.binary));
            actualBinary.addCommandLineOptions(this.args.toArray(new String[this.args.size()]));
            capabilities.setCapability("firefox_binary", (Object)actualBinary);
        }
        if (this.profile != null) {
            capabilities.setCapability("firefox_profile", (Object)this.profile);
        }
        return capabilities;
    }

    public JsonElement toJson() throws IOException {
        JsonObject options = new JsonObject();
        if (this.binary != null) {
            options.addProperty("binary", this.binary);
        }
        if (this.profile != null) {
            for (Map.Entry<String, Boolean> entry : this.booleanPrefs.entrySet()) {
                this.profile.setPreference(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Comparable<Boolean>> entry : this.intPrefs.entrySet()) {
                this.profile.setPreference(entry.getKey(), (Integer)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.stringPrefs.entrySet()) {
                this.profile.setPreference(entry.getKey(), (String)entry.getValue());
            }
            options.addProperty("profile", this.profile.toJson());
        } else {
            JsonObject allPrefs = new JsonObject();
            for (Map.Entry<String, Boolean> entry : this.booleanPrefs.entrySet()) {
                allPrefs.add(entry.getKey(), (JsonElement)new JsonPrimitive(entry.getValue()));
            }
            for (Map.Entry<String, Integer> entry : this.intPrefs.entrySet()) {
                allPrefs.add(entry.getKey(), (JsonElement)new JsonPrimitive((Number)entry.getValue()));
            }
            for (Map.Entry<String, String> entry : this.stringPrefs.entrySet()) {
                allPrefs.add(entry.getKey(), (JsonElement)new JsonPrimitive(entry.getValue()));
            }
            options.add("prefs", (JsonElement)allPrefs);
        }
        JsonArray arguments = new JsonArray();
        for (String string : this.args) {
            arguments.add((JsonElement)new JsonPrimitive(string));
        }
        options.add("args", (JsonElement)arguments);
        return options;
    }
}

