/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.Proxies;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.FirefoxWebElement;
import org.openqa.selenium.firefox.internal.NewProfileExtensionConnection;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.internal.Killable;
import org.openqa.selenium.internal.Lock;
import org.openqa.selenium.internal.SocketLock;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

public class FirefoxDriver
extends RemoteWebDriver
implements TakesScreenshot,
Killable {
    public static final String BINARY = "firefox_binary";
    public static final String PROFILE = "firefox_profile";
    public static final boolean DEFAULT_ENABLE_NATIVE_EVENTS = Platform.getCurrent().is(Platform.WINDOWS);
    @Deprecated
    public static final boolean ACCEPT_UNTRUSTED_CERTIFICATES = true;
    @Deprecated
    public static final boolean ASSUME_UNTRUSTED_ISSUER = true;
    protected FirefoxBinary binary;

    public FirefoxDriver() {
        this(new FirefoxBinary(), null);
    }

    public FirefoxDriver(FirefoxProfile profile) {
        this(new FirefoxBinary(), profile);
    }

    public FirefoxDriver(Capabilities capabilities) {
        this(FirefoxDriver.getBinary(capabilities), FirefoxDriver.extractProfile(capabilities));
    }

    private static FirefoxProfile extractProfile(Capabilities capabilities) {
        FirefoxProfile profile = null;
        if (capabilities.getCapability(PROFILE) != null) {
            Object raw = capabilities.getCapability(PROFILE);
            if (raw instanceof FirefoxProfile) {
                profile = (FirefoxProfile)raw;
            } else if (raw instanceof String) {
                try {
                    profile = FirefoxProfile.fromJson((String)raw);
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
        }
        profile = FirefoxDriver.getProfile(profile);
        if (capabilities.getCapability("proxy") != null) {
            Proxy proxy = Proxies.extractProxy((Capabilities)capabilities);
            profile.setProxyPreferences(proxy);
        }
        if (capabilities.getCapability("acceptSslCerts") != null) {
            Boolean acceptCerts = (Boolean)capabilities.getCapability("acceptSslCerts");
            profile.setAcceptUntrustedCertificates(acceptCerts);
        }
        if (capabilities.getCapability("loggingPrefs") != null) {
            LoggingPreferences logsPrefs = (LoggingPreferences)capabilities.getCapability("loggingPrefs");
            for (String logtype : logsPrefs.getEnabledLogTypes()) {
                profile.setPreference("webdriver.log." + logtype, logsPrefs.getLevel(logtype).intValue());
            }
        }
        return profile;
    }

    private static FirefoxBinary getBinary(Capabilities capabilities) {
        if (capabilities.getCapability(BINARY) != null) {
            Object raw = capabilities.getCapability(BINARY);
            if (raw instanceof FirefoxBinary) {
                return (FirefoxBinary)raw;
            }
            File file = new File((String)raw);
            return new FirefoxBinary(file);
        }
        return new FirefoxBinary();
    }

    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile) {
        super((CommandExecutor)new LazyCommandExecutor(binary, profile), (Capabilities)DesiredCapabilities.firefox());
        this.binary = binary;
        this.setElementConverter(new JsonToWebElementConverter(this){

            protected RemoteWebElement newRemoteWebElement() {
                return new FirefoxWebElement(FirefoxDriver.this);
            }
        });
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public void kill() {
        this.binary.quit();
    }

    public WebDriver.Options manage() {
        return new RemoteWebDriver.RemoteWebDriverOptions(){

            public WebDriver.Timeouts timeouts() {
                return new RemoteWebDriver.RemoteWebDriverOptions.RemoteTimeouts(){

                    public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
                        FirefoxDriver.this.execute("setTimeout", (Map)ImmutableMap.of((Object)"type", (Object)"implicit", (Object)"ms", (Object)TimeUnit.MILLISECONDS.convert(time, unit)));
                        return this;
                    }

                    public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
                        FirefoxDriver.this.execute("setTimeout", (Map)ImmutableMap.of((Object)"type", (Object)"script", (Object)"ms", (Object)TimeUnit.MILLISECONDS.convert(time, unit)));
                        return this;
                    }
                };
            }
        };
    }

    protected void startClient() {
        LazyCommandExecutor exe = (LazyCommandExecutor)this.getCommandExecutor();
        FirefoxProfile profileToUse = FirefoxDriver.getProfile(exe.profile);
        profileToUse.addWebDriverExtensionIfNeeded();
        ExtensionConnection connection = this.connectTo(exe.binary, profileToUse, "localhost");
        exe.setConnection(connection);
        try {
            connection.start();
        }
        catch (IOException e) {
            throw new WebDriverException("An error occurred while connecting to Firefox", (Throwable)e);
        }
    }

    private static FirefoxProfile getProfile(FirefoxProfile profile) {
        FirefoxProfile profileToUse = profile;
        String suggestedProfile = System.getProperty("webdriver.firefox.profile");
        if (profileToUse == null && suggestedProfile != null) {
            profileToUse = new ProfilesIni().getProfile(suggestedProfile);
            if (profileToUse == null) {
                throw new WebDriverException("Firefox profile '" + suggestedProfile + "' named in system property 'webdriver.firefox.profile' not found");
            }
        } else if (profileToUse == null) {
            profileToUse = new FirefoxProfile();
        }
        return profileToUse;
    }

    protected ExtensionConnection connectTo(FirefoxBinary binary, FirefoxProfile profile, String host) {
        Lock lock = this.obtainLock();
        try {
            FirefoxBinary bin = binary == null ? new FirefoxBinary() : binary;
            NewProfileExtensionConnection newProfileExtensionConnection = new NewProfileExtensionConnection(lock, bin, profile, host);
            return newProfileExtensionConnection;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    protected Lock obtainLock() {
        return new SocketLock();
    }

    protected void stopClient() {
        ((LazyCommandExecutor)this.getCommandExecutor()).quit();
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        String base64 = this.execute("screenshot").getValue().toString();
        return (X)target.convertFromBase64Png(base64);
    }

    private static class LazyCommandExecutor
    implements CommandExecutor {
        private ExtensionConnection connection;
        private final FirefoxBinary binary;
        private final FirefoxProfile profile;

        private LazyCommandExecutor(FirefoxBinary binary, FirefoxProfile profile) {
            this.binary = binary;
            this.profile = profile;
        }

        public void setConnection(ExtensionConnection connection) {
            this.connection = connection;
        }

        public void quit() {
            if (this.connection != null) {
                this.connection.quit();
                this.connection = null;
            }
            if (this.profile != null) {
                this.profile.cleanTemporaryModel();
            }
        }

        public Response execute(Command command) throws IOException {
            if (this.connection == null) {
                if (command.getName().equals("quit")) {
                    return null;
                }
                throw new WebDriverException("The FirefoxDriver cannot be used after quit() was called.");
            }
            return this.connection.execute(command);
        }
    }
}

