/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.Executable;
import org.openqa.selenium.firefox.internal.Streams;
import org.openqa.selenium.internal.FileHandler;
import org.openqa.selenium.internal.ProcessUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxBinary {
    private static final String NO_FOCUS_LIBRARY_NAME = "x_ignore_nofocus.so";
    private final Map<String, String> extraEnv = new HashMap<String, String>();
    private final Executable executable;
    private Process process;
    private long timeout = TimeUnit.SECONDS.toMillis(45L);
    private OutputStream stream;
    private Thread outputWatcher;

    public FirefoxBinary() {
        this(null);
    }

    public FirefoxBinary(File pathToFirefoxBinary) {
        this.executable = new Executable(pathToFirefoxBinary);
    }

    protected boolean isOnLinux() {
        return Platform.getCurrent().is(Platform.LINUX);
    }

    public void startProfile(FirefoxProfile profile, File profileDir, String ... commandLineFlags) throws IOException {
        String profileAbsPath = profileDir.getAbsolutePath();
        this.setEnvironmentProperty("XRE_PROFILE_PATH", profileAbsPath);
        this.setEnvironmentProperty("MOZ_NO_REMOTE", "1");
        this.setEnvironmentProperty("MOZ_CRASHREPORTER_DISABLE", "1");
        this.setEnvironmentProperty("NO_EM_RESTART", "1");
        if (this.isOnLinux() && (profile.enableNativeEvents() || profile.alwaysLoadNoFocusLib())) {
            this.modifyLinkLibraryPath(profileDir);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getExecutable().getPath());
        commands.add("--verbose");
        commands.addAll(Arrays.asList(commandLineFlags));
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.redirectErrorStream(true);
        builder.environment().putAll(this.getExtraEnv());
        this.getExecutable().setLibraryPath(builder, this.getExtraEnv());
        if (this.stream == null) {
            this.stream = this.getExecutable().getDefaultOutputStream();
        }
        this.startFirefoxProcess(builder);
        this.copeWithTheStrangenessOfTheMac(builder);
        this.startOutputWatcher();
    }

    protected void startFirefoxProcess(ProcessBuilder builder) throws IOException {
        this.process = builder.start();
    }

    protected void startOutputWatcher() {
        this.outputWatcher = new Thread((Runnable)new OutputWatcher(this.process, this.stream), "Firefox output watcher");
        this.outputWatcher.start();
    }

    protected Executable getExecutable() {
        return this.executable;
    }

    public Map<String, String> getExtraEnv() {
        return Collections.unmodifiableMap(this.extraEnv);
    }

    protected void modifyLinkLibraryPath(File profileDir) {
        String existingLdLibPath = System.getenv("LD_LIBRARY_PATH");
        String newLdLibPath = this.extractAndCheck(profileDir, NO_FOCUS_LIBRARY_NAME, "x86", "amd64");
        if (existingLdLibPath != null && !existingLdLibPath.equals("")) {
            newLdLibPath = newLdLibPath + existingLdLibPath;
        }
        this.setEnvironmentProperty("LD_LIBRARY_PATH", newLdLibPath);
        this.setEnvironmentProperty("LD_PRELOAD", NO_FOCUS_LIBRARY_NAME);
    }

    protected String extractAndCheck(File profileDir, String noFocusSoName, String jarPath32Bit, String jarPath64Bit) {
        HashSet<String> pathsSet = new HashSet<String>();
        pathsSet.add(jarPath32Bit);
        pathsSet.add(jarPath64Bit);
        StringBuilder builtPath = new StringBuilder();
        for (String path : pathsSet) {
            try {
                FileHandler.copyResource((File)profileDir, this.getClass(), (String[])new String[]{path + File.separator + noFocusSoName});
            }
            catch (IOException e) {
                if (Boolean.getBoolean("webdriver.development")) {
                    System.err.println("Exception unpacking required library, but in development mode. Continuing");
                }
                throw new WebDriverException((Throwable)e);
            }
            String outSoPath = profileDir.getAbsolutePath() + File.separator + path;
            File file = new File(outSoPath, noFocusSoName);
            if (!file.exists()) {
                throw new WebDriverException("Could not locate " + path + ": " + "native events will not work.");
            }
            builtPath.append(outSoPath).append(":");
        }
        return builtPath.toString();
    }

    protected void copeWithTheStrangenessOfTheMac(ProcessBuilder builder) throws IOException {
        if (Platform.getCurrent().is(Platform.MAC)) {
            try {
                this.sleep(300L);
                if (this.process.exitValue() == 0) {
                    return;
                }
                this.sleep(10000L);
                this.startFirefoxProcess(builder);
            }
            catch (IllegalThreadStateException e) {
                // empty catch block
            }
            try {
                this.sleep(300L);
                this.process.exitValue();
                if (this.process.exitValue() == 0) {
                    return;
                }
                StringBuilder message = new StringBuilder("Unable to start firefox cleanly.\n");
                message.append(this.getConsoleOutput()).append("\n");
                message.append("Exit value: ").append(this.process.exitValue()).append("\n");
                message.append("Ran from: ").append(builder.command()).append("\n");
                throw new WebDriverException(message.toString());
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    public void setEnvironmentProperty(String propertyName, String value) {
        if (propertyName == null || value == null) {
            throw new WebDriverException(String.format("You must set both the property name and value: %s, %s", propertyName, value));
        }
        this.extraEnv.put(propertyName, value);
    }

    public void createProfile(String profileName) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.executable.getPath(), "--verbose", "-CreateProfile", profileName).redirectErrorStream(true);
        builder.environment().put("MOZ_NO_REMOTE", "1");
        if (this.stream == null) {
            this.stream = this.executable.getDefaultOutputStream();
        }
        this.startFirefoxProcess(builder);
        this.outputWatcher = new Thread(new OutputWatcher(this.process, this.stream));
        this.outputWatcher.start();
    }

    public void waitFor() throws InterruptedException, IOException {
        this.process.waitFor();
    }

    public String getConsoleOutput() throws IOException {
        if (this.process == null) {
            return null;
        }
        return Streams.drainStream(this.stream);
    }

    private void sleep(long timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void clean(FirefoxProfile profile, File profileDir) throws IOException {
        this.startProfile(profile, profileDir, "-silent");
        try {
            this.waitFor();
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            while (profile.isRunning(profileDir)) {
                this.sleep(500L);
            }
            do {
                this.sleep(500L);
            } while (profile.isRunning(profileDir));
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return "FirefoxBinary(" + this.executable.getPath() + ")";
    }

    public void setOutputWatcher(OutputStream stream) {
        this.stream = stream;
    }

    public void quit() {
        ProcessUtils.killProcess((Process)this.process);
    }

    private static class OutputWatcher
    implements Runnable {
        private final Process process;
        private OutputStream stream;
        private final int BUFSIZE = 4096;

        public OutputWatcher(Process process, OutputStream stream) {
            this.process = process;
            this.stream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InputStream stdoutOfWatchedProcess = null;
            try {
                int n;
                stdoutOfWatchedProcess = this.process.getInputStream();
                byte[] buffer = new byte[4096];
                do {
                    int avail = Math.min(4096, stdoutOfWatchedProcess.available());
                    n = stdoutOfWatchedProcess.read(buffer, 0, avail = Math.max(avail, 1));
                    if (n <= 0 || this.stream == null) continue;
                    try {
                        this.stream.write(buffer, 0, n);
                    }
                    catch (IOException e) {
                        System.err.print("ERROR: Could not write to " + this.stream + ": ");
                        e.printStackTrace(System.err);
                        this.stream = null;
                    }
                } while (n != -1);
            }
            catch (IOException e) {
                System.err.print("ERROR: Could not read from stdout of " + this.process + ": ");
                e.printStackTrace(System.err);
            }
            finally {
                if (stdoutOfWatchedProcess != null) {
                    try {
                        stdoutOfWatchedProcess.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

