/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edgehtml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.service.DriverService;

public class EdgeHtmlDriverService
extends DriverService {
    public static final String EDGEHTML_DRIVER_EXE_PROPERTY = "webdriver.edgehtml.driver";
    public static final String EDGEHTML_DRIVER_LOG_PROPERTY = "webdriver.edgehtml.logfile";
    public static final String EDGEHTML_DRIVER_VERBOSE_LOG_PROPERTY = "webdriver.edgehtml.verboseLogging";

    public EdgeHtmlDriverService(File executable, int port, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, args, environment);
    }

    public EdgeHtmlDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, args, environment);
    }

    public static EdgeHtmlDriverService createDefaultService() {
        return (EdgeHtmlDriverService)new Builder().build();
    }

    public static class Builder
    extends DriverService.Builder<EdgeHtmlDriverService, Builder> {
        private boolean verbose = Boolean.getBoolean("webdriver.edgehtml.verboseLogging");

        public int score(Capabilities capabilities) {
            Object useChromium;
            int score = 0;
            if ("MicrosoftEdge".equals(capabilities.getBrowserName())) {
                ++score;
            }
            if ((useChromium = capabilities.getCapability("ms:edgeChromium")) == null || Objects.equals(useChromium, true)) {
                --score;
            }
            return score;
        }

        public Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        protected File findDefaultExecutable() {
            return EdgeHtmlDriverService.findExecutable((String)"MicrosoftWebDriver", (String)EdgeHtmlDriverService.EDGEHTML_DRIVER_EXE_PROPERTY, (String)"https://github.com/SeleniumHQ/selenium/wiki/MicrosoftWebDriver", (String)"http://go.microsoft.com/fwlink/?LinkId=619687");
        }

        protected List<String> createArgs() {
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("--port=%d", this.getPort()));
            if (this.verbose) {
                args.add("--verbose");
            }
            return Collections.unmodifiableList(args);
        }

        protected EdgeHtmlDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                EdgeHtmlDriverService service = new EdgeHtmlDriverService(exe, port, timeout, args, environment);
                if (this.getLogFile() != null) {
                    service.sendOutputTo(new FileOutputStream(this.getLogFile()));
                } else {
                    String logFile = System.getProperty(EdgeHtmlDriverService.EDGEHTML_DRIVER_LOG_PROPERTY);
                    if (logFile != null) {
                        service.sendOutputTo(new FileOutputStream(logFile));
                    }
                }
                return service;
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

