/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chromium.ChromiumDriverInfo;
import org.openqa.selenium.edge.EdgeDriver;

public abstract class EdgeDriverInfo
extends ChromiumDriverInfo {
    public String getDisplayName() {
        return "Edge";
    }

    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", (Object)"MicrosoftEdge");
    }

    public boolean isSupporting(Capabilities capabilities) {
        return "MicrosoftEdge".equals(capabilities.getBrowserName()) || capabilities.getCapability("edgeOptions") != null;
    }

    public abstract boolean isAvailable();

    public int getMaximumSimultaneousSessions() {
        return Runtime.getRuntime().availableProcessors() + 1;
    }

    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        return Optional.of(new EdgeDriver(capabilities));
    }
}

