/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.performance;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.performance.model.Metric;
import org.openqa.selenium.devtools.performance.model.Metrics;
import org.openqa.selenium.json.JsonInput;

public class Performance {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Performance.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable(Optional<EnableTimeDomain> timeDomain) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        timeDomain.ifPresent(p -> params.put((Object)"timeDomain", (Object)p));
        return new Command<Void>("Performance.enable", (Map<String, Object>)params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> setTimeDomain(SetTimeDomainTimeDomain timeDomain) {
        Objects.requireNonNull(timeDomain, "timeDomain is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"timeDomain", (Object)timeDomain);
        return new Command<Void>("Performance.setTimeDomain", (Map<String, Object>)params.build());
    }

    public static Command<List<Metric>> getMetrics() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<Metric>>("Performance.getMetrics", (Map<String, Object>)params.build(), ConverterFunctions.map("metrics", new TypeToken<List<Metric>>(){}.getType()));
    }

    public static Event<Metrics> metrics() {
        return new Event<Metrics>("Performance.metrics", input -> (Metrics)input.read(Metrics.class));
    }

    public static enum SetTimeDomainTimeDomain {
        TIMETICKS("timeTicks"),
        THREADTICKS("threadTicks");

        private String value;

        private SetTimeDomainTimeDomain(String value) {
            this.value = value;
        }

        public static SetTimeDomainTimeDomain fromString(String s) {
            return Arrays.stream(SetTimeDomainTimeDomain.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetTimeDomainTimeDomain "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetTimeDomainTimeDomain fromJson(JsonInput input) {
            return SetTimeDomainTimeDomain.fromString(input.nextString());
        }
    }

    public static enum EnableTimeDomain {
        TIMETICKS("timeTicks"),
        THREADTICKS("threadTicks");

        private String value;

        private EnableTimeDomain(String value) {
            this.value = value;
        }

        public static EnableTimeDomain fromString(String s) {
            return Arrays.stream(EnableTimeDomain.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within EnableTimeDomain "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static EnableTimeDomain fromJson(JsonInput input) {
            return EnableTimeDomain.fromString(input.nextString());
        }
    }
}

