/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.network.model.Headers;
import org.openqa.selenium.devtools.network.model.ResourceTiming;
import org.openqa.selenium.devtools.network.model.SecurityDetails;
import org.openqa.selenium.devtools.security.model.SecurityState;
import org.openqa.selenium.json.JsonInput;

public class Response {
    private final String url;
    private final Integer status;
    private final String statusText;
    private final Headers headers;
    private final Optional<String> headersText;
    private final String mimeType;
    private final Optional<Headers> requestHeaders;
    private final Optional<String> requestHeadersText;
    private final Boolean connectionReused;
    private final Number connectionId;
    private final Optional<String> remoteIPAddress;
    private final Optional<Integer> remotePort;
    private final Optional<Boolean> fromDiskCache;
    private final Optional<Boolean> fromServiceWorker;
    private final Optional<Boolean> fromPrefetchCache;
    private final Number encodedDataLength;
    private final Optional<ResourceTiming> timing;
    private final Optional<String> protocol;
    private final SecurityState securityState;
    private final Optional<SecurityDetails> securityDetails;

    public Response(String url, Integer status, String statusText, Headers headers, Optional<String> headersText, String mimeType, Optional<Headers> requestHeaders, Optional<String> requestHeadersText, Boolean connectionReused, Number connectionId, Optional<String> remoteIPAddress, Optional<Integer> remotePort, Optional<Boolean> fromDiskCache, Optional<Boolean> fromServiceWorker, Optional<Boolean> fromPrefetchCache, Number encodedDataLength, Optional<ResourceTiming> timing, Optional<String> protocol, SecurityState securityState, Optional<SecurityDetails> securityDetails) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.status = Objects.requireNonNull(status, "status is required");
        this.statusText = Objects.requireNonNull(statusText, "statusText is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.headersText = headersText;
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType is required");
        this.requestHeaders = requestHeaders;
        this.requestHeadersText = requestHeadersText;
        this.connectionReused = Objects.requireNonNull(connectionReused, "connectionReused is required");
        this.connectionId = Objects.requireNonNull(connectionId, "connectionId is required");
        this.remoteIPAddress = remoteIPAddress;
        this.remotePort = remotePort;
        this.fromDiskCache = fromDiskCache;
        this.fromServiceWorker = fromServiceWorker;
        this.fromPrefetchCache = fromPrefetchCache;
        this.encodedDataLength = Objects.requireNonNull(encodedDataLength, "encodedDataLength is required");
        this.timing = timing;
        this.protocol = protocol;
        this.securityState = Objects.requireNonNull(securityState, "securityState is required");
        this.securityDetails = securityDetails;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Optional<String> getHeadersText() {
        return this.headersText;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Optional<Headers> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Optional<String> getRequestHeadersText() {
        return this.requestHeadersText;
    }

    public Boolean getConnectionReused() {
        return this.connectionReused;
    }

    public Number getConnectionId() {
        return this.connectionId;
    }

    public Optional<String> getRemoteIPAddress() {
        return this.remoteIPAddress;
    }

    public Optional<Integer> getRemotePort() {
        return this.remotePort;
    }

    public Optional<Boolean> getFromDiskCache() {
        return this.fromDiskCache;
    }

    public Optional<Boolean> getFromServiceWorker() {
        return this.fromServiceWorker;
    }

    public Optional<Boolean> getFromPrefetchCache() {
        return this.fromPrefetchCache;
    }

    public Number getEncodedDataLength() {
        return this.encodedDataLength;
    }

    public Optional<ResourceTiming> getTiming() {
        return this.timing;
    }

    public Optional<String> getProtocol() {
        return this.protocol;
    }

    public SecurityState getSecurityState() {
        return this.securityState;
    }

    public Optional<SecurityDetails> getSecurityDetails() {
        return this.securityDetails;
    }

    private static Response fromJson(JsonInput input) {
        String url = null;
        Integer status = null;
        String statusText = null;
        Headers headers = null;
        Optional<String> headersText = Optional.empty();
        String mimeType = null;
        Optional<Headers> requestHeaders = Optional.empty();
        Optional<String> requestHeadersText = Optional.empty();
        Boolean connectionReused = null;
        Number connectionId = null;
        Optional<String> remoteIPAddress = Optional.empty();
        Optional<Integer> remotePort = Optional.empty();
        Optional<Boolean> fromDiskCache = Optional.empty();
        Optional<Boolean> fromServiceWorker = Optional.empty();
        Optional<Boolean> fromPrefetchCache = Optional.empty();
        Number encodedDataLength = null;
        Optional<ResourceTiming> timing = Optional.empty();
        Optional<String> protocol = Optional.empty();
        SecurityState securityState = null;
        Optional<SecurityDetails> securityDetails = Optional.empty();
        input.beginObject();
        block44: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block44;
                }
                case "status": {
                    status = input.nextNumber().intValue();
                    continue block44;
                }
                case "statusText": {
                    statusText = input.nextString();
                    continue block44;
                }
                case "headers": {
                    headers = (Headers)((Object)input.read(Headers.class));
                    continue block44;
                }
                case "headersText": {
                    headersText = Optional.ofNullable(input.nextString());
                    continue block44;
                }
                case "mimeType": {
                    mimeType = input.nextString();
                    continue block44;
                }
                case "requestHeaders": {
                    requestHeaders = Optional.ofNullable((Headers)((Object)input.read(Headers.class)));
                    continue block44;
                }
                case "requestHeadersText": {
                    requestHeadersText = Optional.ofNullable(input.nextString());
                    continue block44;
                }
                case "connectionReused": {
                    connectionReused = input.nextBoolean();
                    continue block44;
                }
                case "connectionId": {
                    connectionId = input.nextNumber();
                    continue block44;
                }
                case "remoteIPAddress": {
                    remoteIPAddress = Optional.ofNullable(input.nextString());
                    continue block44;
                }
                case "remotePort": {
                    remotePort = Optional.ofNullable(input.nextNumber().intValue());
                    continue block44;
                }
                case "fromDiskCache": {
                    fromDiskCache = Optional.ofNullable(input.nextBoolean());
                    continue block44;
                }
                case "fromServiceWorker": {
                    fromServiceWorker = Optional.ofNullable(input.nextBoolean());
                    continue block44;
                }
                case "fromPrefetchCache": {
                    fromPrefetchCache = Optional.ofNullable(input.nextBoolean());
                    continue block44;
                }
                case "encodedDataLength": {
                    encodedDataLength = input.nextNumber();
                    continue block44;
                }
                case "timing": {
                    timing = Optional.ofNullable((ResourceTiming)input.read(ResourceTiming.class));
                    continue block44;
                }
                case "protocol": {
                    protocol = Optional.ofNullable(input.nextString());
                    continue block44;
                }
                case "securityState": {
                    securityState = (SecurityState)((Object)input.read(SecurityState.class));
                    continue block44;
                }
                case "securityDetails": {
                    securityDetails = Optional.ofNullable((SecurityDetails)input.read(SecurityDetails.class));
                    continue block44;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Response(url, status, statusText, headers, headersText, mimeType, requestHeaders, requestHeadersText, connectionReused, connectionId, remoteIPAddress, remotePort, fromDiskCache, fromServiceWorker, fromPrefetchCache, encodedDataLength, timing, protocol, securityState, securityDetails);
    }
}

