package org.openqa.selenium.devtools.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Emitted only when `page.interceptFileChooser` is enabled.
 */
public class FileChooserOpened {

    public enum Mode {

        SELECTSINGLE("selectSingle"), SELECTMULTIPLE("selectMultiple");

        private String value;

        Mode(String value) {
            this.value = value;
        }

        public static Mode fromString(String s) {
            return java.util.Arrays.stream(Mode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Mode "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Mode fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final org.openqa.selenium.devtools.page.model.FrameId frameId;

    private final org.openqa.selenium.devtools.dom.model.BackendNodeId backendNodeId;

    private final Mode mode;

    public FileChooserOpened(org.openqa.selenium.devtools.page.model.FrameId frameId, org.openqa.selenium.devtools.dom.model.BackendNodeId backendNodeId, Mode mode) {
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.backendNodeId = java.util.Objects.requireNonNull(backendNodeId, "backendNodeId is required");
        this.mode = java.util.Objects.requireNonNull(mode, "mode is required");
    }

    /**
     * Id of the frame containing input node.
     */
    @Beta()
    public org.openqa.selenium.devtools.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * Input node id.
     */
    @Beta()
    public org.openqa.selenium.devtools.dom.model.BackendNodeId getBackendNodeId() {
        return backendNodeId;
    }

    /**
     * Input mode.
     */
    public Mode getMode() {
        return mode;
    }

    private static FileChooserOpened fromJson(JsonInput input) {
        org.openqa.selenium.devtools.page.model.FrameId frameId = null;
        org.openqa.selenium.devtools.dom.model.BackendNodeId backendNodeId = null;
        Mode mode = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.page.model.FrameId.class);
                    break;
                case "backendNodeId":
                    backendNodeId = input.read(org.openqa.selenium.devtools.dom.model.BackendNodeId.class);
                    break;
                case "mode":
                    mode = Mode.fromString(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FileChooserOpened(frameId, backendNodeId, mode);
    }
}
