package org.openqa.selenium.devtools.media.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Corresponds to kMediaError
 */
public class PlayerError {

    public enum Type {

        PIPELINE_ERROR("pipeline_error"), MEDIA_ERROR("media_error");

        private String value;

        Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return java.util.Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Type fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final Type type;

    private final java.lang.String errorCode;

    public PlayerError(Type type, java.lang.String errorCode) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.errorCode = java.util.Objects.requireNonNull(errorCode, "errorCode is required");
    }

    public Type getType() {
        return type;
    }

    /**
     * When this switches to using media::Status instead of PipelineStatus
     * we can remove "errorCode" and replace it with the fields from
     * a Status instance. This also seems like a duplicate of the error
     * level enum - there is a todo bug to have that level removed and
     * use this instead. (crbug.com/1068454)
     */
    public java.lang.String getErrorCode() {
        return errorCode;
    }

    private static PlayerError fromJson(JsonInput input) {
        Type type = null;
        java.lang.String errorCode = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = Type.fromString(input.nextString());
                    break;
                case "errorCode":
                    errorCode = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PlayerError(type, errorCode);
    }
}
