/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.page.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ScreencastFrameMetadata {
    private final Number offsetTop;
    private final Number pageScaleFactor;
    private final Number deviceWidth;
    private final Number deviceHeight;
    private final Number scrollOffsetX;
    private final Number scrollOffsetY;
    private final TimeSinceEpoch timestamp;

    public ScreencastFrameMetadata(Number offsetTop, Number pageScaleFactor, Number deviceWidth, Number deviceHeight, Number scrollOffsetX, Number scrollOffsetY, TimeSinceEpoch timestamp) {
        this.offsetTop = Objects.requireNonNull(offsetTop, "offsetTop is required");
        this.pageScaleFactor = Objects.requireNonNull(pageScaleFactor, "pageScaleFactor is required");
        this.deviceWidth = Objects.requireNonNull(deviceWidth, "deviceWidth is required");
        this.deviceHeight = Objects.requireNonNull(deviceHeight, "deviceHeight is required");
        this.scrollOffsetX = Objects.requireNonNull(scrollOffsetX, "scrollOffsetX is required");
        this.scrollOffsetY = Objects.requireNonNull(scrollOffsetY, "scrollOffsetY is required");
        this.timestamp = timestamp;
    }

    public Number getOffsetTop() {
        return this.offsetTop;
    }

    public Number getPageScaleFactor() {
        return this.pageScaleFactor;
    }

    public Number getDeviceWidth() {
        return this.deviceWidth;
    }

    public Number getDeviceHeight() {
        return this.deviceHeight;
    }

    public Number getScrollOffsetX() {
        return this.scrollOffsetX;
    }

    public Number getScrollOffsetY() {
        return this.scrollOffsetY;
    }

    public TimeSinceEpoch getTimestamp() {
        return this.timestamp;
    }

    private static ScreencastFrameMetadata fromJson(JsonInput input) {
        Number offsetTop = null;
        Number pageScaleFactor = null;
        Number deviceWidth = null;
        Number deviceHeight = null;
        Number scrollOffsetX = null;
        Number scrollOffsetY = null;
        TimeSinceEpoch timestamp = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "offsetTop": {
                    offsetTop = input.nextNumber();
                    continue block18;
                }
                case "pageScaleFactor": {
                    pageScaleFactor = input.nextNumber();
                    continue block18;
                }
                case "deviceWidth": {
                    deviceWidth = input.nextNumber();
                    continue block18;
                }
                case "deviceHeight": {
                    deviceHeight = input.nextNumber();
                    continue block18;
                }
                case "scrollOffsetX": {
                    scrollOffsetX = input.nextNumber();
                    continue block18;
                }
                case "scrollOffsetY": {
                    scrollOffsetY = input.nextNumber();
                    continue block18;
                }
                case "timestamp": {
                    timestamp = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScreencastFrameMetadata(offsetTop, pageScaleFactor, deviceWidth, deviceHeight, scrollOffsetX, scrollOffsetY, timestamp);
    }
}

