/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.Headers;
import org.openqa.selenium.json.JsonInput;

public class WebSocketResponse {
    private final Integer status;
    private final String statusText;
    private final Headers headers;
    private final String headersText;
    private final Headers requestHeaders;
    private final String requestHeadersText;

    public WebSocketResponse(Integer status, String statusText, Headers headers, String headersText, Headers requestHeaders, String requestHeadersText) {
        this.status = Objects.requireNonNull(status, "status is required");
        this.statusText = Objects.requireNonNull(statusText, "statusText is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.headersText = headersText;
        this.requestHeaders = requestHeaders;
        this.requestHeadersText = requestHeadersText;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getHeadersText() {
        return this.headersText;
    }

    public Headers getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getRequestHeadersText() {
        return this.requestHeadersText;
    }

    private static WebSocketResponse fromJson(JsonInput input) {
        Integer status = null;
        String statusText = null;
        Headers headers = null;
        String headersText = null;
        Headers requestHeaders = null;
        String requestHeadersText = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "status": {
                    status = input.nextNumber().intValue();
                    continue block16;
                }
                case "statusText": {
                    statusText = input.nextString();
                    continue block16;
                }
                case "headers": {
                    headers = (Headers)((Object)input.read(Headers.class));
                    continue block16;
                }
                case "headersText": {
                    headersText = input.nextString();
                    continue block16;
                }
                case "requestHeaders": {
                    requestHeaders = (Headers)((Object)input.read(Headers.class));
                    continue block16;
                }
                case "requestHeadersText": {
                    requestHeadersText = input.nextString();
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new WebSocketResponse(status, statusText, headers, headersText, requestHeaders, requestHeadersText);
    }
}

