/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AuthChallenge {
    private final Source source;
    private final String origin;
    private final String scheme;
    private final String realm;

    public AuthChallenge(Source source, String origin, String scheme, String realm) {
        this.source = source;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.scheme = Objects.requireNonNull(scheme, "scheme is required");
        this.realm = Objects.requireNonNull(realm, "realm is required");
    }

    public Source getSource() {
        return this.source;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getRealm() {
        return this.realm;
    }

    private static AuthChallenge fromJson(JsonInput input) {
        Source source = null;
        String origin = null;
        String scheme = null;
        String realm = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "source": {
                    source = Source.fromString(input.nextString());
                    continue block12;
                }
                case "origin": {
                    origin = input.nextString();
                    continue block12;
                }
                case "scheme": {
                    scheme = input.nextString();
                    continue block12;
                }
                case "realm": {
                    realm = input.nextString();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AuthChallenge(source, origin, scheme, realm);
    }

    public static enum Source {
        SERVER("Server"),
        PROXY("Proxy");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public static Source fromString(String s) {
            return Arrays.stream(Source.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Source "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Source fromJson(JsonInput input) {
            return Source.fromString(input.nextString());
        }
    }
}

