/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.layertree;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.dom.model.Rect;
import org.openqa.selenium.devtools.layertree.model.Layer;
import org.openqa.selenium.devtools.layertree.model.LayerId;
import org.openqa.selenium.devtools.layertree.model.LayerPainted;
import org.openqa.selenium.devtools.layertree.model.PaintProfile;
import org.openqa.selenium.devtools.layertree.model.PictureTile;
import org.openqa.selenium.devtools.layertree.model.SnapshotId;

@Beta
public class LayerTree {
    public static Command<List<String>> compositingReasons(LayerId layerId) {
        Objects.requireNonNull(layerId, "layerId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"layerId", (Object)layerId);
        return new Command<List<String>>("LayerTree.compositingReasons", (Map<String, Object>)params.build(), ConverterFunctions.map("compositingReasons", new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("LayerTree.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("LayerTree.enable", (Map<String, Object>)params.build());
    }

    public static Command<SnapshotId> loadSnapshot(List<PictureTile> tiles) {
        Objects.requireNonNull(tiles, "tiles is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"tiles", tiles);
        return new Command<SnapshotId>("LayerTree.loadSnapshot", (Map<String, Object>)params.build(), ConverterFunctions.map("snapshotId", SnapshotId.class));
    }

    public static Command<SnapshotId> makeSnapshot(LayerId layerId) {
        Objects.requireNonNull(layerId, "layerId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"layerId", (Object)layerId);
        return new Command<SnapshotId>("LayerTree.makeSnapshot", (Map<String, Object>)params.build(), ConverterFunctions.map("snapshotId", SnapshotId.class));
    }

    public static Command<List<PaintProfile>> profileSnapshot(SnapshotId snapshotId, Optional<Integer> minRepeatCount, Optional<Number> minDuration, Optional<Rect> clipRect) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"snapshotId", (Object)snapshotId);
        minRepeatCount.ifPresent(p -> params.put((Object)"minRepeatCount", p));
        minDuration.ifPresent(p -> params.put((Object)"minDuration", p));
        clipRect.ifPresent(p -> params.put((Object)"clipRect", p));
        return new Command<List<PaintProfile>>("LayerTree.profileSnapshot", (Map<String, Object>)params.build(), ConverterFunctions.map("timings", new TypeToken<List<PaintProfile>>(){}.getType()));
    }

    public static Command<Void> releaseSnapshot(SnapshotId snapshotId) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"snapshotId", (Object)snapshotId);
        return new Command<Void>("LayerTree.releaseSnapshot", (Map<String, Object>)params.build());
    }

    public static Command<String> replaySnapshot(SnapshotId snapshotId, Optional<Integer> fromStep, Optional<Integer> toStep, Optional<Number> scale) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"snapshotId", (Object)snapshotId);
        fromStep.ifPresent(p -> params.put((Object)"fromStep", p));
        toStep.ifPresent(p -> params.put((Object)"toStep", p));
        scale.ifPresent(p -> params.put((Object)"scale", p));
        return new Command<String>("LayerTree.replaySnapshot", (Map<String, Object>)params.build(), ConverterFunctions.map("dataURL", String.class));
    }

    public static Command<List<Map<String, Object>>> snapshotCommandLog(SnapshotId snapshotId) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"snapshotId", (Object)snapshotId);
        return new Command<List<Map<String, Object>>>("LayerTree.snapshotCommandLog", (Map<String, Object>)params.build(), ConverterFunctions.map("commandLog", new TypeToken<List<Map<String, Object>>>(){}.getType()));
    }

    public static Event<LayerPainted> layerPainted() {
        return new Event<LayerPainted>("LayerTree.layerPainted", input -> (LayerPainted)input.read(LayerPainted.class));
    }

    public static Event<List<Layer>> layerTreeDidChange() {
        return new Event<List<Layer>>("LayerTree.layerTreeDidChange", ConverterFunctions.map("layers", new TypeToken<List<Layer>>(){}.getType()));
    }
}

