/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.headlessexperimental.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class ScreenshotParams {
    private final Format format;
    private final Integer quality;

    public ScreenshotParams(Format format, Integer quality) {
        this.format = format;
        this.quality = quality;
    }

    public Format getFormat() {
        return this.format;
    }

    public Integer getQuality() {
        return this.quality;
    }

    private static ScreenshotParams fromJson(JsonInput input) {
        Format format = null;
        Integer quality = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "format": {
                    format = Format.fromString(input.nextString());
                    continue block8;
                }
                case "quality": {
                    quality = input.nextNumber().intValue();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScreenshotParams(format, quality);
    }

    public static enum Format {
        JPEG("jpeg"),
        PNG("png");

        private String value;

        private Format(String value) {
            this.value = value;
        }

        public static Format fromString(String s) {
            return Arrays.stream(Format.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Format "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Format fromJson(JsonInput input) {
            return Format.fromString(input.nextString());
        }
    }
}

