/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.css.model;

import java.util.Objects;
import org.openqa.selenium.devtools.css.model.SourceRange;
import org.openqa.selenium.json.JsonInput;

public class CSSProperty {
    private final String name;
    private final String value;
    private final Boolean important;
    private final Boolean implicit;
    private final String text;
    private final Boolean parsedOk;
    private final Boolean disabled;
    private final SourceRange range;

    public CSSProperty(String name, String value, Boolean important, Boolean implicit, String text, Boolean parsedOk, Boolean disabled, SourceRange range) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
        this.important = important;
        this.implicit = implicit;
        this.text = text;
        this.parsedOk = parsedOk;
        this.disabled = disabled;
        this.range = range;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Boolean getImportant() {
        return this.important;
    }

    public Boolean getImplicit() {
        return this.implicit;
    }

    public String getText() {
        return this.text;
    }

    public Boolean getParsedOk() {
        return this.parsedOk;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public SourceRange getRange() {
        return this.range;
    }

    private static CSSProperty fromJson(JsonInput input) {
        String name = null;
        String value = null;
        Boolean important = null;
        Boolean implicit = null;
        String text = null;
        Boolean parsedOk = null;
        Boolean disabled = null;
        SourceRange range = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block20;
                }
                case "value": {
                    value = input.nextString();
                    continue block20;
                }
                case "important": {
                    important = input.nextBoolean();
                    continue block20;
                }
                case "implicit": {
                    implicit = input.nextBoolean();
                    continue block20;
                }
                case "text": {
                    text = input.nextString();
                    continue block20;
                }
                case "parsedOk": {
                    parsedOk = input.nextBoolean();
                    continue block20;
                }
                case "disabled": {
                    disabled = input.nextBoolean();
                    continue block20;
                }
                case "range": {
                    range = (SourceRange)input.read(SourceRange.class);
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSProperty(name, value, important, implicit, text, parsedOk, disabled, range);
    }
}

